package org.lsst.ccs.config;


import javax.persistence.Embedded;
import java.io.Serializable;
import javax.persistence.Embeddable;
import javax.persistence.EmbeddedId;


/**
 * this is an explicit duplication of description of parameter as it is in the subsystem configuration.
 */
@Embeddable
public class ParameterBase implements Serializable, PathObject {
    private static final long serialVersionUID = -1173880414018123185L;

    ParameterPath /*@NotNull*/ path ;
    /**
     * type of parameter: class Name.
     * should have a valueOf(String) method
     */
    String /*@NotNull*/ typeName ;
    
    /**
     * default value as String
     * TODO: define a possible NULL value!
     */
    String /*@Nullable*/ defaultValue ;

    protected ParameterBase() {
    }
    
    //////////////////////////// CONSTRUCTORS
    
    public ParameterBase(String componentName, String codeName, String parameterName, String type, String defaultValue) {
        //TODO: check for null!
        this.path = new ParameterPath(componentName,codeName,parameterName);
        this.typeName = type;
        this.defaultValue = defaultValue;
    }
//////////////////////// ACCESSORS/MUTATORS
    
    public String getComponentName() {
        return path.componentName;
    }
    
    void setComponentName(String componentName) {
        this.path.componentName = componentName;
    }
    
    public String getCodeName() {
        return path.codeName;
    }
    
    void setCodeName(String codeName) {
        this.path.codeName = codeName;
    }
    
    public String getParameterName() {
        return path.parameterName;
    }
    
    void setParameterName(String parameterName) {
        this.path.parameterName = parameterName;
    }
    
    public String getTypeName() {
        return typeName;
    }
    
    void setTypeName(String typeName) {
        this.typeName = typeName;
    }
    
    public String getDefaultValue() {
        return defaultValue;
    }
    
    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }
    
    //hack: do not know why it's working here and not on member!
    @Embedded
    @EmbeddedId
    public ParameterPath getPath() {
        return path;
    }
    
    void setPath(ParameterPath path) {
        this.path = path;
    }
//////////////////// IDENT METHODS
    //TODO use PathObject
    
    /**
     * special equals: works with all PathObjects
     * @param o
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof PathObject)) return false;
        
        PathObject that = (PathObject) o ;
        if(! this.getPath().equals(that.getPath())) return false ;
        
        return true;
    }
    
    @Override
    public int hashCode() {
        return path.hashCode() ;
    }
    
    @Override
    public String toString() {
        return "{" +
                "path=" + path.toString() +
                '}';
    }
    
}
