package org.lsst.ccs.config;


import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.lsst.ccs.config.utilities.ConfigUtils;

/**
 * Writes properties files in memory.
 * Use for test purposes only
 * @author The LSST CCS Teams
 */

class InMemoryWriterProvider implements LocalConfigurationProxy.WriterProvider {
    
    private final Map <String, ByteArrayOutputStream> propertiesMap = new HashMap<String, ByteArrayOutputStream>();
    
    /**
     * Private default constructor
     */
    public InMemoryWriterProvider(){
        
    }
    
    @Override
    public PrintWriter getPrintWriter(String configName, String tagName, String categoryName) throws IOException {
        String configFileName = ConfigUtils.baseNameFromNames(configName, tagName, categoryName);
        if ( ! configFileName.endsWith(".properties") ) {
            configFileName += ".properties";
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Writer writer = new OutputStreamWriter(bos) ;
        propertiesMap.put(configFileName, bos);
        return new PrintWriter(writer) ;
    }
    
    public  String printConfig(String configFileName) {
        if ( ! configFileName.endsWith(".properties") ) {
            configFileName += ".properties";
        }
        return propertiesMap.get(configFileName).toString() ;
    }
    
    
    public String printConfigNames(){
        String result = "[";
        for (String s : propertiesMap.keySet()){
            result += s+",";
        }
        return result.substring(0, result.length()-1)+"]";
    }
    
    public Properties getConfigurationProperties(String configName, String tag, String cat) throws IOException {
        String configFileName = ConfigUtils.baseNameFromNames(configName, tag, cat);
        if ( ! configFileName.endsWith(".properties") ) {
            configFileName += ".properties";
        }
        Properties props = new Properties() ;
        ByteArrayOutputStream bos = propertiesMap.get(configFileName);
        if (bos == null) {
            return null;
        }
        byte[] array = bos.toByteArray() ;
        
        props.load(new InputStreamReader(new ByteArrayInputStream(array)));
        
        return props ;
    }
    
    public void clearPropertiesMap(){
        propertiesMap.clear();
    }
}