/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.Serializable;
import java.util.Collection;
import org.lsst.ccs.config.AConfigProfile;
import org.lsst.ccs.config.AParameterConfiguration;
import org.lsst.ccs.config.AParameterDescription;
import org.lsst.ccs.config.ASubsystemDescription;
import org.lsst.ccs.config.ConfigProfile;
import org.lsst.ccs.config.DescriptionMismatchListener;
import org.lsst.ccs.config.ParameterBase;
import org.lsst.ccs.config.ParameterConfiguration;
import org.lsst.ccs.config.ParameterDescription;
import org.lsst.ccs.config.SubsystemDescription;

public class Factories {
    private Factories() {
    }

    public static SubsystemDescription createRawSubsystemDescription(String subsystemName, String tag, Serializable configurationData) {
        return new ASubsystemDescription(subsystemName, tag, configurationData);
    }

    public static SubsystemDescription createSubsystemDescription(String subsystemName, String tag, Serializable configurationData, Collection<ParameterDescription> parameterDescriptions) {
        SubsystemDescription res = Factories.createRawSubsystemDescription(subsystemName, tag, configurationData);
        res.addParameterDescriptions(parameterDescriptions);
        return res;
    }

    public static SubsystemDescription createSubsystemDescriptionCopy(SubsystemDescription desc) {
        return new ASubsystemDescription(desc);
    }

    public static ParameterDescription createParameterDescription(ParameterBase parameterBase, String description, String simpleName, String category, int level) {
        return new AParameterDescription(parameterBase, description, simpleName, category, level);
    }

    public static ParameterDescription createParameterDescription(ParameterDescription other) {
        return new AParameterDescription(other);
    }

    public static void tryCopyParameters(SubsystemDescription newDescription, SubsystemDescription model, DescriptionMismatchListener mismatchListener) {
        System.err.println("Try copy Parameters not implemented yet");
    }

    public static ConfigProfile createRawConfigProfile(SubsystemDescription subsystemDesc, String category, String configName) {
        if (!(subsystemDesc instanceof ASubsystemDescription)) {
            throw new IllegalArgumentException("deprecated Description");
        }
        return Factories.createRawConfigProfile((ASubsystemDescription)subsystemDesc, category, configName);
    }

    static AConfigProfile createRawConfigProfile(ASubsystemDescription subsystemDesc, String categoryName, String configName) {
        return new AConfigProfile(subsystemDesc, categoryName, configName);
    }

    public static ConfigProfile copyProfile(ConfigProfile toBeCopied, String newName, boolean toEngineering) {
        if (toBeCopied instanceof AConfigProfile) {
            return new AConfigProfile((AConfigProfile)toBeCopied, toEngineering, newName);
        }
        if (toEngineering) {
            throw new IllegalArgumentException("cannot create an engineering profile from a deprecated one");
        }
        throw new UnsupportedOperationException("copy with deprecated profile not yet implemented");
    }

    public static ParameterConfiguration createParameterConfiguration(ParameterDescription description, String value) {
        if (!(description instanceof AParameterDescription)) {
            throw new IllegalArgumentException("deprecated description");
        }
        if (description.getId() == 0L) {
            throw new IllegalArgumentException("ParameterDescription not registered in base" + description);
        }
        return new AParameterConfiguration((AParameterDescription)description, value);
    }

    public static ParameterConfiguration createParameterConfiguration(ParameterDescription description) {
        if (!(description instanceof AParameterDescription)) {
            throw new IllegalArgumentException("deprecated description");
        }
        if (description.getId() == 0L) {
            throw new IllegalArgumentException("ParameterDescription not registered in base" + description);
        }
        return new AParameterConfiguration((AParameterDescription)description);
    }
}

