/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.config.Factories;
import org.lsst.ccs.config.InMemoryWriterProvider;
import org.lsst.ccs.config.LocalConfigurationProxy;
import org.lsst.ccs.config.ParameterBase;
import org.lsst.ccs.config.ParameterDescription;
import org.lsst.ccs.config.SubsystemDescription;

public class LocalConfigurationProxyTest {
    private static SubsystemDescription subDesc;
    private static InMemoryWriterProvider writerProvider;
    private static final String[] cats;
    private static final String subName = "subName";
    private static final String tagName = "subTag";

    @BeforeClass
    public static void setupClass() {
        subDesc = Factories.createRawSubsystemDescription((String)subName, (String)tagName, (Serializable)((Object)""));
        ArrayList<ParameterDescription> parmDescs = new ArrayList<ParameterDescription>();
        ParameterBase parmBase = new ParameterBase("comp1", "", "parmD", "java.lang.Integer", "0");
        parmDescs.add(Factories.createParameterDescription((ParameterBase)parmBase, (String)"", (String)"", (String)cats[0], (int)0));
        parmBase = new ParameterBase("comp1", "", "parmA", "java.lang.Integer", "0");
        parmDescs.add(Factories.createParameterDescription((ParameterBase)parmBase, (String)"", (String)"", (String)cats[1], (int)0));
        parmBase = new ParameterBase("comp1", "", "parmB", "java.lang.Integer", "0");
        parmDescs.add(Factories.createParameterDescription((ParameterBase)parmBase, (String)"", (String)"", (String)cats[2], (int)0));
        parmBase = new ParameterBase("comp2", "", "parmD", "java.lang.Integer", "0");
        parmDescs.add(Factories.createParameterDescription((ParameterBase)parmBase, (String)"", (String)"", (String)cats[0], (int)0));
        parmBase = new ParameterBase("comp2", "", "parmA", "java.lang.Double", "0");
        parmDescs.add(Factories.createParameterDescription((ParameterBase)parmBase, (String)"", (String)"", (String)cats[1], (int)0));
        parmBase = new ParameterBase("comp2", "", "parmB", "java.lang.Integer", "0");
        parmDescs.add(Factories.createParameterDescription((ParameterBase)parmBase, (String)"", (String)"", (String)cats[2], (int)0));
        parmBase = new ParameterBase("comp3", "", "parmD", "java.lang.Integer", "0");
        parmDescs.add(Factories.createParameterDescription((ParameterBase)parmBase, (String)"", (String)"", (String)cats[0], (int)0));
        parmBase = new ParameterBase("comp3", "", "parmA", "java.lang.Integer", "0");
        parmDescs.add(Factories.createParameterDescription((ParameterBase)parmBase, (String)"", (String)"", (String)cats[1], (int)0));
        parmBase = new ParameterBase("comp3", "", "parmB", "java.lang.Integer", "0");
        parmDescs.add(Factories.createParameterDescription((ParameterBase)parmBase, (String)"", (String)"", (String)cats[2], (int)0));
        subDesc.addParameterDescriptions(parmDescs);
        writerProvider = InMemoryWriterProvider.newInstance();
    }

    @Test
    public void testGetInitialParameterConfiguration() throws Exception {
        LocalConfigurationProxy proxy = new LocalConfigurationProxy(subDesc);
        Set categorySet = proxy.getCategorySet();
        Assert.assertEquals((long)cats.length, (long)categorySet.size());
        Assert.assertTrue((boolean)categorySet.containsAll(Arrays.asList(cats)));
        HashMap<String, String> taggedCategories = new HashMap<String, String>();
        String[] tags = new String[]{"", "", "conf1"};
        for (int i = 0; i < cats.length; ++i) {
            taggedCategories.put(cats[i], tags[i]);
        }
        try {
            Map.Entry res = proxy.getInitialParameterConfigurations(taggedCategories);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        tags = new String[]{"", "", ""};
        for (int i = 0; i < cats.length; ++i) {
            taggedCategories.put(cats[i], tags[i]);
        }
        Map.Entry res = proxy.getInitialParameterConfigurations(taggedCategories);
        Assert.assertEquals((Object)ConfigurationState.CONFIGURED, res.getKey());
        Assert.assertEquals((long)0L, (long)((Set)res.getValue()).size());
        PrintWriter printWriter = writerProvider.getPrintWriter("", tagName, cats[2]);
        printWriter.println("comp1//parmB=1");
        printWriter.println("comp2//parmB=1");
        printWriter.println("comp3//parmB=1");
        printWriter.flush();
        printWriter.close();
        res = proxy.getInitialParameterConfigurations(taggedCategories);
        Assert.assertEquals((Object)ConfigurationState.CONFIGURED, res.getKey());
        Assert.assertEquals((long)3L, (long)((Set)res.getValue()).size());
        printWriter = writerProvider.getPrintWriter("config1", tagName, cats[1]);
        printWriter.println("comp1//parmA=2");
        printWriter.println("comp2//parmA=2");
        printWriter.println("comp3//parmA=2");
        printWriter.flush();
        printWriter.close();
        taggedCategories.put(cats[1], "config1");
        res = proxy.getInitialParameterConfigurations(taggedCategories);
        Assert.assertEquals((Object)ConfigurationState.CONFIGURED, res.getKey());
        Assert.assertEquals((long)6L, (long)((Set)res.getValue()).size());
    }

    @Test
    public void testSaveConfiguration() throws Exception {
        writerProvider = InMemoryWriterProvider.newInstance();
        LocalConfigurationProxy proxy = new LocalConfigurationProxy(subDesc);
        HashMap<String, String> taggedCategories = new HashMap<String, String>();
        for (int i = 0; i < cats.length; ++i) {
            taggedCategories.put(cats[i], "");
        }
        proxy.getInitialParameterConfigurations(taggedCategories);
        Assert.assertFalse((boolean)proxy.isDirty());
        proxy.notifyParameterChange("comp3", "parmD", "1");
        proxy.notifyParameterChange("comp1", "parmA", "2");
        proxy.notifyParameterChange("comp2", "parmA", "2");
        proxy.notifyParameterChange("comp2", "parmB", "4");
        Assert.assertTrue((boolean)proxy.isDirty());
        taggedCategories.clear();
        taggedCategories.put("catB", "configB1");
        taggedCategories.put("catA", "configA1");
        proxy.saveChangesForCategoriesAs(taggedCategories);
        Assert.assertTrue((boolean)proxy.isDirty());
        Properties props = writerProvider.getConfigurationProperties("configB1", tagName, "catB");
        Assert.assertEquals((long)1L, (long)props.size());
        Assert.assertEquals((Object)"4", (Object)props.getProperty("comp2//parmB"));
        props = writerProvider.getConfigurationProperties("configA1", tagName, "catA");
        Assert.assertEquals((long)2L, (long)props.size());
        Assert.assertEquals((Object)"2", (Object)props.getProperty("comp1//parmA"));
        Assert.assertEquals((Object)"2", (Object)props.getProperty("comp2//parmA"));
        props = writerProvider.getConfigurationProperties("", tagName, "");
        Assert.assertNull((Object)props);
        taggedCategories.clear();
        taggedCategories.put("", "config1");
        proxy.saveChangesForCategoriesAs(taggedCategories);
        Assert.assertFalse((boolean)proxy.isDirty());
        props = writerProvider.getConfigurationProperties("config1", tagName, "");
        Assert.assertEquals((long)1L, (long)props.size());
        Assert.assertEquals((Object)"1", (Object)props.getProperty("comp3//parmD"));
        taggedCategories.put("", "config2");
        proxy.saveChangesForCategoriesAs(taggedCategories);
        props = writerProvider.getConfigurationProperties("config2", tagName, "");
        Assert.assertEquals((long)1L, (long)props.size());
        Assert.assertEquals((Object)"1", (Object)props.getProperty("comp3//parmD"));
        proxy.notifyParameterChange("comp2", "parmA", "17");
        proxy.notifyParameterChange("comp3", "parmA", "17");
        taggedCategories.clear();
        taggedCategories.put("catA", "");
        proxy.saveChangesForCategoriesAs(taggedCategories);
        props = writerProvider.getConfigurationProperties("", tagName, "catA");
        Assert.assertEquals((long)3L, (long)props.size());
        Assert.assertEquals((Object)"2", (Object)props.getProperty("comp1//parmA"));
        Assert.assertEquals((Object)"17", (Object)props.getProperty("comp2//parmA"));
        Assert.assertEquals((Object)"17", (Object)props.getProperty("comp3//parmA"));
        proxy.writeMissingDefaultConfigs();
        props = writerProvider.getConfigurationProperties("", tagName, "catA");
        Assert.assertEquals((long)3L, (long)props.size());
        props = writerProvider.getConfigurationProperties("", tagName, "catB");
        Assert.assertEquals((long)0L, (long)props.size());
        props = writerProvider.getConfigurationProperties("", tagName, "");
        Assert.assertEquals((long)0L, (long)props.size());
    }

    @Test
    public void testLoadConfiguration() throws Exception {
        writerProvider = InMemoryWriterProvider.newInstance();
        PrintWriter printWriter = writerProvider.getPrintWriter("configA1", tagName, cats[1]);
        printWriter.println("comp1//parmA=1");
        printWriter.println("comp3//parmA=1");
        printWriter.flush();
        printWriter.close();
        printWriter = writerProvider.getPrintWriter("configA2", tagName, cats[1]);
        printWriter.println("comp2//parmA=1");
        printWriter.flush();
        printWriter.close();
        printWriter = writerProvider.getPrintWriter("configB1", tagName, cats[2]);
        printWriter.println("comp1//parmB=1");
        printWriter.println("comp3//parmB=1");
        printWriter.flush();
        printWriter.close();
        printWriter = writerProvider.getPrintWriter("configB2", tagName, cats[2]);
        printWriter.println("comp2//parmB=1");
        printWriter.flush();
        printWriter.close();
        printWriter = writerProvider.getPrintWriter("configD1", tagName, cats[0]);
        printWriter.println("comp1//parmD=1");
        printWriter.println("comp3//parmD=1");
        printWriter.flush();
        printWriter.close();
        LocalConfigurationProxy proxy = new LocalConfigurationProxy(subDesc);
        HashMap<String, String> taggedCategories = new HashMap<String, String>();
        taggedCategories.put("catA", "configA1");
        taggedCategories.put("catB", "configB1");
        taggedCategories.put("", "");
        proxy.getInitialParameterConfigurations(taggedCategories);
        Assert.assertFalse((boolean)proxy.isDirty());
        taggedCategories.clear();
        taggedCategories.put("catA", "configA2");
        taggedCategories.put("catB", "configB2");
        taggedCategories.put("", "configD1");
        Map changesToPerform = proxy.loadCategories(taggedCategories);
        Assert.assertEquals((long)3L, (long)changesToPerform.size());
        Properties props = (Properties)changesToPerform.get("comp1");
        Assert.assertEquals((long)3L, (long)props.size());
        Assert.assertEquals((Object)"0", (Object)props.getProperty("parmA"));
        Assert.assertEquals((Object)"0", (Object)props.getProperty("parmB"));
        Assert.assertEquals((Object)"1", (Object)props.getProperty("parmD"));
        props = (Properties)changesToPerform.get("comp2");
        Assert.assertEquals((long)2L, (long)props.size());
        Assert.assertEquals((Object)"1", (Object)props.getProperty("parmA"));
        Assert.assertEquals((Object)"1", (Object)props.getProperty("parmB"));
        props = (Properties)changesToPerform.get("comp3");
        Assert.assertEquals((long)3L, (long)props.size());
        Assert.assertEquals((Object)"0", (Object)props.getProperty("parmA"));
        Assert.assertEquals((Object)"0", (Object)props.getProperty("parmB"));
        Assert.assertEquals((Object)"1", (Object)props.getProperty("parmD"));
    }

    static {
        cats = new String[]{"", "catA", "catB"};
    }
}

