/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import org.hibernate.annotations.Immutable;
import org.lsst.ccs.config.AConfigProfile;
import org.lsst.ccs.config.AParameterConfiguration;
import org.lsst.ccs.config.ConfigProfile;
import org.lsst.ccs.config.GhostParameterDescription;
import org.lsst.ccs.config.GhostSubsystemDescription;
import org.lsst.ccs.config.ImmutableStateException;
import org.lsst.ccs.config.ParameterConfiguration;
import org.lsst.ccs.config.ParameterDescription;
import org.lsst.ccs.config.PastParameterConfiguration;
import org.lsst.ccs.config.SubsystemDescription;

@Entity
@Immutable
class PastConfigProfile
extends ConfigProfile {
    private static final long serialVersionUID = 1424069242594632758L;
    @Id
    private long id;
    @ManyToOne(fetch=FetchType.EAGER)
    private GhostSubsystemDescription subsystemDesc;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    private Set<PastParameterConfiguration> parameterConfigurations;

    PastConfigProfile() {
    }

    public PastConfigProfile(GhostSubsystemDescription ghost, AConfigProfile oldProfile) {
        super(oldProfile.getSubsystemName(), oldProfile.getTag(), oldProfile.getCategoryName(), oldProfile.getConfigName());
        if (oldProfile.getId() == 0L) {
            throw new IllegalArgumentException("trying to create history date from non registered data");
        }
        if (ghost.getId() != oldProfile.getSubsystemId()) {
            throw new IllegalArgumentException("ghost and profile have no common ID");
        }
        this.subsystemDesc = ghost;
        this.id = oldProfile.getId();
        this.setStartTimestamp(oldProfile.getStartTimestamp());
        HashSet<PastParameterConfiguration> set = new HashSet<PastParameterConfiguration>();
        for (AParameterConfiguration conf : oldProfile.getParameterConfigurations()) {
            ParameterDescription description = ghost.fetch(conf);
            GhostParameterDescription ghostDesc = (GhostParameterDescription)description;
            PastParameterConfiguration pastConf = new PastParameterConfiguration(ghostDesc, conf);
            set.add(pastConf);
        }
        this.parameterConfigurations = Collections.unmodifiableSet(set);
        this.setPreviousConfigID(oldProfile.getPreviousConfigID());
        long endDate = System.currentTimeMillis();
        this.setEndTimestamp(endDate);
        oldProfile.setEndTimestamp(endDate);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    protected void setId(long id) {
        this.id = id;
    }

    @Override
    public SubsystemDescription getSubsystemDescription() {
        return this.subsystemDesc;
    }

    @Override
    public Set<? extends ParameterConfiguration> getModifiedParameters() {
        return Collections.unmodifiableSet(this.parameterConfigurations);
    }

    @Override
    public ParameterConfiguration temporaryChangeConfigurationValue(String parameterPath, long time, String value, boolean checked) {
        throw new ImmutableStateException("no modification of deprecated data");
    }

    @Override
    public void addParameterConfiguration(String parameterName, String value) {
        throw new ImmutableStateException("no modification of deprecated data");
    }

    @Override
    public void addParameterConfigurations(ParameterConfiguration ... parameterConfigurations) {
        throw new ImmutableStateException("no modification of deprecated data");
    }

    @Override
    public void removeParameterConfigurations(ParameterConfiguration ... parameterConfigurations) {
        throw new ImmutableStateException("no modification of deprecated data");
    }

    public GhostSubsystemDescription getSubsystemDesc() {
        return this.subsystemDesc;
    }

    void setSubsystemDesc(GhostSubsystemDescription subsystemDesc) {
        this.subsystemDesc = subsystemDesc;
    }

    public Set<PastParameterConfiguration> getParameterConfigurations() {
        return Collections.unmodifiableSet(this.parameterConfigurations);
    }

    void setParameterConfigurations(Set<PastParameterConfiguration> parameterConfigurations) {
        this.parameterConfigurations = Collections.unmodifiableSet(parameterConfigurations);
    }

    @Override
    public boolean isDirty() {
        return false;
    }
}

