/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.messages.AgentInfo;
import org.lsst.ccs.bus.messages.StatusConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.states.AgentState;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.config.ConfigurationProxy;
import org.lsst.ccs.config.utilities.ConfigUtils;
import org.lsst.ccs.description.ComponentLookupService;
import org.lsst.ccs.framework.Configurable;
import org.lsst.ccs.framework.ConfigurationServiceException;
import org.lsst.ccs.utilities.structs.ViewValue;

public abstract class ConfigurableSubsystem
extends Subsystem {
    private ConfigurationProxy configurationProxy;
    private final Set<String> categories;
    private final ConfigurationState initialState;
    private final Map<String, Map<String, ViewValue>> bulkChanges = new ConcurrentHashMap<String, Map<String, ViewValue>>();

    public ConfigurableSubsystem(String name, ConfigurationProxy configProxy, ConfigurationState initialState) {
        super(name, AgentInfo.AgentType.WORKER);
        this.configurationProxy = configProxy;
        this.categories = configProxy.getCategorySet();
        this.initialState = initialState;
    }

    public String getTag() {
        return this.configurationProxy.getTagName();
    }

    public ConfigurationProxy getConfigurationProxy() {
        return this.configurationProxy;
    }

    protected void setConfigurationProxy(ConfigurationProxy configurationProxy) {
        this.configurationProxy = configurationProxy;
    }

    @Command(description="Saves all changes in the current configurations", type=Command.CommandType.CONFIGURATION)
    public final void saveAllChanges() throws ConfigurationServiceException {
        this.saveChangesForCategoriesAsInternal(this.configurationProxy.getTaggedCategoriesForCats(this.categories));
    }

    @Command(description="Saves the specified categories with a name", type=Command.CommandType.CONFIGURATION)
    public final void saveChangesForCategories(String ... categories) throws ConfigurationServiceException {
        this.saveChangesForCategoriesAsInternal(this.configurationProxy.getTaggedCategoriesForCats(ConfigUtils.parseCategories(this.categories, categories)));
    }

    @Command(description="Saves the specified categories with a name", type=Command.CommandType.CONFIGURATION)
    public final void saveChangesForCategoriesAs(String ... taggedCategories) throws ConfigurationServiceException {
        this.saveChangesForCategoriesAsInternal(this.parseConfigurationString(taggedCategories));
    }

    private void saveChangesForCategoriesAsInternal(Map<String, String> taggedCategories) throws ConfigurationServiceException {
        if (taggedCategories.isEmpty()) {
            return;
        }
        String message = "";
        try {
            this.configurationProxy.saveChangesForCategoriesAs(taggedCategories);
        }
        catch (ConfigurationServiceException ex) {
            message = ex.getMessage();
            throw ex;
        }
        finally {
            this.updateStateAndSendStatusConfigurationInfo(message, Collections.EMPTY_SET);
        }
    }

    @Command(description="drop all unsaved changes", type=Command.CommandType.CONFIGURATION)
    public void dropAllChanges() throws Exception {
        this.dropChangesInternal(this.categories);
    }

    @Command(description="drop unsaved changes for the specified categories", type=Command.CommandType.CONFIGURATION)
    public void dropChangesForCategories(String ... categories) throws Exception {
        this.dropChangesInternal(ConfigUtils.parseCategories(this.categories, categories));
    }

    private void dropChangesInternal(Set<String> categoriesSet) throws Exception {
        this.dropBulkChange();
        Map<String, Properties> changes = this.configurationProxy.loadCategories(this.configurationProxy.getTaggedCategoriesForCats(categoriesSet));
        for (Map.Entry<String, Properties> changesForComponent : changes.entrySet()) {
            for (String parameterName : changesForComponent.getValue().stringPropertyNames()) {
                this.submitChange(changesForComponent.getKey(), parameterName, changesForComponent.getValue().getProperty(parameterName));
            }
        }
        this.validateBulkChanges();
        Set<Map.Entry<String, String>> processedParameters = this.bulkChange();
        this.configurationProxy.saveModifications(this.configurationProxy.getTaggedCategoriesForCats(categoriesSet));
        this.updateStateAndSendStatusConfigurationInfo("", processedParameters);
    }

    @Command(description="loads a new configuration", type=Command.CommandType.CONFIGURATION)
    public void loadConfiguration(String ... taggedCategories) throws ConfigurationServiceException, Exception {
        this.loadCategoriesInternal(ConfigUtils.parseConfigurationStringWithDefaults(this.categories, taggedCategories));
    }

    @Command(description="loads the configuration for the specified categories", type=Command.CommandType.CONFIGURATION)
    public void loadCategories(String ... taggedCategories) throws ConfigurationServiceException, Exception {
        if (taggedCategories.length == 0) {
            return;
        }
        this.loadCategoriesInternal(this.parseConfigurationString(taggedCategories));
    }

    private void loadCategoriesInternal(Map<String, String> categoryProfile) throws ConfigurationServiceException, Exception {
        this.dropBulkChange();
        Map<String, Properties> changes = this.configurationProxy.loadCategories(categoryProfile);
        for (Map.Entry<String, Properties> changesForComponent : changes.entrySet()) {
            for (String parameterName : changesForComponent.getValue().stringPropertyNames()) {
                this.submitChange(changesForComponent.getKey(), parameterName, changesForComponent.getValue().getProperty(parameterName));
            }
        }
        this.validateBulkChanges();
        Set<Map.Entry<String, String>> processedParms = this.bulkChange();
        this.configurationProxy.saveModifications(categoryProfile);
        this.updateStateAndSendStatusConfigurationInfo("", processedParms);
    }

    @Command(description="return a ConfigurationInfo object", type=Command.CommandType.CONFIGURATION)
    public ConfigurationInfo getConfigurationInfo() {
        return this.configurationProxy.buildConfigurationInfo((ConfigurationState)this.getState(ConfigurationState.class), Collections.EMPTY_SET);
    }

    public abstract ComponentLookupService getLookup();

    private Map<String, String> parseConfigurationString(String ... taggedCategories) {
        return ConfigUtils.parseConfigurationString(this.categories, taggedCategories);
    }

    void singleChange(String componentName, String parameterName, Object value) throws Exception {
        ViewValue viewValue = this.configurationProxy.checkForParameterChange(componentName, parameterName, value);
        Configurable component = (Configurable)this.getLookup().getComponentByName(componentName);
        this.updateInternalState("", new AgentState[]{ConfigurationState.CONFIGURING});
        Map<String, ViewValue> parametersView = this.configurationProxy.getCurrentValuesForComponent(componentName);
        parametersView.put(parameterName, viewValue);
        component.validateBulkChange(parametersView.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> ((ViewValue)entry.getValue()).getValue())));
        HashMap<String, Object> change = new HashMap<String, Object>();
        change.put(parameterName, value);
        Map others = component.setBulkParameter(change);
        if (others.isEmpty()) {
            this.configurationProxy.notifyParameterChange(componentName, parameterName, viewValue.getView());
        } else {
            Method m = component.getEnvironment().getConfigMethodOfComponent(parameterName);
            try {
                m.invoke((Object)component, viewValue.getValue());
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            this.configurationProxy.notifyParameterChange(componentName, parameterName, viewValue.getView());
        }
        HashSet<Map.Entry<String, String>> changeName = new HashSet<Map.Entry<String, String>>();
        changeName.add(new AbstractMap.SimpleEntry<String, String>(componentName, parameterName));
        this.updateStateAndSendStatusConfigurationInfo("", changeName);
    }

    @Command(description="Submits a change of parameter to be validated later", type=Command.CommandType.CONFIGURATION)
    public void submitChange(String componentName, String parameterName, Object value) {
        ViewValue viewValue = this.configurationProxy.checkForParameterChange(componentName, parameterName, value);
        Map<String, ViewValue> map = this.bulkChanges.get(componentName);
        if (map == null) {
            map = new LinkedHashMap<String, ViewValue>();
            this.bulkChanges.put(componentName, map);
        }
        map.put(parameterName, viewValue);
    }

    @Command(description="processes the bulk change", type=Command.CommandType.CONFIGURATION)
    public void commitBulkChange() {
        this.validateBulkChanges();
        Set<Map.Entry<String, String>> processedParms = this.bulkChange();
        this.updateStateAndSendStatusConfigurationInfo("", processedParms);
    }

    private void validateBulkChanges() {
        this.getLookup().proceduralWalk(null, Configurable.class, null, c -> {
            Map<String, ViewValue> changesForComponent = this.bulkChanges.get(c.getName());
            if (changesForComponent == null) {
                return;
            }
            Map<String, ViewValue> parametersView = this.configurationProxy.getCurrentValuesForComponent(c.getName());
            parametersView.putAll(changesForComponent);
            c.validateBulkChange(parametersView.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> ((ViewValue)entry.getValue()).getValue())));
        });
    }

    private Set<Map.Entry<String, String>> bulkChange() {
        this.updateInternalState("", new AgentState[]{ConfigurationState.CONFIGURING});
        final HashSet<Map.Entry<String, String>> processedParms = new HashSet<Map.Entry<String, String>>();
        this.getLookup().proceduralWalk(null, Configurable.class, null, (Consumer)new Consumer<Configurable>(){

            @Override
            public void accept(Configurable c) {
                Map changesForComponent = (Map)ConfigurableSubsystem.this.bulkChanges.get(c.getName());
                if (changesForComponent == null) {
                    return;
                }
                Map others = Collections.EMPTY_MAP;
                try {
                    others = c.setBulkParameter(changesForComponent.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> ((ViewValue)entry.getValue()).getValue())));
                }
                catch (Exception ex) {
                    ConfigurableSubsystem.this.updateInternalState("", new AgentState[]{ConfigurationState.UNCONFIGURED});
                    ConfigurableSubsystem.this.dropBulkChange();
                    throw new RuntimeException(ex);
                }
                for (String parmName : changesForComponent.keySet()) {
                    if (others.containsKey(parmName)) continue;
                    ConfigurableSubsystem.this.configurationProxy.notifyParameterChange(c.getName(), parmName, ((ViewValue)changesForComponent.get(parmName)).getView());
                    processedParms.add(new AbstractMap.SimpleEntry<String, String>(c.getName(), parmName));
                }
                for (String parmName : others.keySet()) {
                    Method m = c.getEnvironment().getConfigMethodOfComponent(parmName);
                    ViewValue parmViewValue = (ViewValue)changesForComponent.get(parmName);
                    try {
                        m.invoke((Object)c, parmViewValue.getValue());
                        ConfigurableSubsystem.this.configurationProxy.notifyParameterChange(c.getName(), parmName, parmViewValue.getView());
                        processedParms.add(new AbstractMap.SimpleEntry<String, String>(c.getName(), parmName));
                    }
                    catch (Exception ex) {
                        ConfigurableSubsystem.this.updateStateAndSendStatusConfigurationInfo(ex.getMessage(), processedParms);
                        ConfigurableSubsystem.this.dropBulkChange();
                        throw new RuntimeException(ex);
                    }
                }
            }
        });
        this.dropBulkChange();
        return processedParms;
    }

    @Command(description="Drops the submitted changes", type=Command.CommandType.CONFIGURATION)
    public void dropBulkChange() {
        this.bulkChanges.clear();
    }

    public void doStart() {
        ConfigurationInfo configInfo = this.configurationProxy.buildConfigurationInfo(this.initialState, Collections.EMPTY_SET);
        this.updateInternalState("", new AgentState[]{this.initialState});
        this.getMessagingAccess().sendStatusMessage((StatusMessage)new StatusConfigurationInfo(configInfo, this.getState()));
    }

    private void updateStateAndSendStatusConfigurationInfo(String message, Set<Map.Entry<String, String>> recentChanges) {
        ConfigurationState configState = this.configurationProxy.isDirty() ? ConfigurationState.DIRTY : ConfigurationState.CONFIGURED;
        this.updateInternalState(message, new AgentState[]{configState});
        this.getMessagingAccess().sendStatusMessage((StatusMessage)new StatusConfigurationInfo(this.configurationProxy.buildConfigurationInfo(configState, recentChanges), this.getState()));
    }
}

