package org.lsst.ccs.config;

import javax.persistence.Embeddable;
import java.io.Serializable;

/**
 * A data structure that contains name of subsystem, configuration and tag AND CAT
 * @author bamade
 */
// Date: 12/04/12

    @Embeddable
public class NamesAndTag implements Serializable {
    private static final long serialVersionUID = -3581991261638846892L;
    private String subsystemName ;
    private String configName ;
    private String tag ;
    private String cat;

    NamesAndTag() {
    }
    
    public NamesAndTag(String subsystemName, String configNames, String tag, String cat) {
        this.subsystemName = subsystemName;
        this.configName = (configNames==null)?"":configNames;
        this.tag = (tag==null)?"":tag;
        this.cat = (cat==null)?"":cat;
    }

    
    public NamesAndTag(String subsystemName, String configNames, String tag) {
       this(subsystemName, configNames, tag, "");
    }
    
    public String getSubsystemName() {
        return subsystemName;
    }

    public void setSubsystemName(String subsystemName) {
        this.subsystemName = subsystemName;
    }

    public String getConfigName() {
        return configName;
    }

    public void setConfigName(String configName) {
        this.configName = (configName==null)?"":configName;
    }

    public String getTag() {
        return tag;
    }
    
    public void setTag(String tag) {
        this.tag = (tag==null)?"":tag;
    }
    
    public String getCat(){
        return cat;
    }
    
    public void setCat(String cat){
        this.cat = (cat == null)?"":cat;
    }
    
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        NamesAndTag that = (NamesAndTag) o;

        if (!configName.equals(that.configName)) return false;
        if (!subsystemName.equals(that.subsystemName)) return false;
        if (!tag.equals(that.tag)) return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result = subsystemName.hashCode();
        result = 31 * result + configName.hashCode();
        result = 31 * result + tag.hashCode();
        return result;
    }

    public String toString() {
        return subsystemName+'_'+configName+'_'+tag ;
    }
}
