/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.Serializable;
import java.util.Collection;
import org.lsst.ccs.config.AConfigProfile;
import org.lsst.ccs.config.AParameterConfiguration;
import org.lsst.ccs.config.AParameterDescription;
import org.lsst.ccs.config.ASubsystemDescription;
import org.lsst.ccs.config.ConfigProfile;
import org.lsst.ccs.config.ConfigurationMismatchListener;
import org.lsst.ccs.config.DataFlavour;
import org.lsst.ccs.config.DescriptionMismatchListener;
import org.lsst.ccs.config.ParameterBase;
import org.lsst.ccs.config.ParameterConfiguration;
import org.lsst.ccs.config.ParameterDescription;
import org.lsst.ccs.config.ParameterFilter;
import org.lsst.ccs.config.SubsystemDescription;

public class Factories {
    private Factories() {
    }

    public static SubsystemDescription createRawSubsystemDescription(String subsystemName, String tag, String user, String version, Serializable configurationData, DataFlavour dataFlavour) {
        return new ASubsystemDescription(subsystemName, tag, user, version, configurationData, dataFlavour);
    }

    public static SubsystemDescription createSubsystemDescription(String subsystemName, String tag, String user, String version, Serializable configurationData, DataFlavour dataFlavour, ParameterFilter filter) {
        SubsystemDescription res = Factories.createRawSubsystemDescription(subsystemName, tag, user, version, configurationData, dataFlavour);
        Collection<ParameterDescription> descriptions = res.getPossibleDescriptions(10, filter);
        res.addParameterDescriptions(descriptions);
        return res;
    }

    public static SubsystemDescription createSubsystemDescriptionCopy(SubsystemDescription desc) {
        return new ASubsystemDescription(desc);
    }

    public static ParameterDescription createParameterDescription(ParameterBase parameterBase, String description, String simpleName, String constraints, String category, int level) {
        return new AParameterDescription(parameterBase, description, simpleName, constraints, category, level);
    }

    public static ParameterDescription createParameterDescription(ParameterDescription other) {
        return new AParameterDescription(other);
    }

    public static void tryCopyParameters(SubsystemDescription newDescription, SubsystemDescription model, DescriptionMismatchListener mismatchListener) {
        System.err.println("Try copy Parameters not implemented yet");
    }

    public static ConfigProfile createRawConfigProfile(SubsystemDescription subsystemDesc, String userName, int level, String category, String configName) {
        if (!(subsystemDesc instanceof ASubsystemDescription)) {
            throw new IllegalArgumentException("deprecated Description");
        }
        return Factories.createRawConfigProfile((ASubsystemDescription)subsystemDesc, userName, level, category, configName);
    }

    static AConfigProfile createRawConfigProfile(ASubsystemDescription subsystemDesc, String userName, int level, String categoryName, String configName) {
        return new AConfigProfile(subsystemDesc, userName, level, categoryName, configName);
    }

    public static ConfigProfile createConfigProfile(SubsystemDescription subsystemDesc, String userName, int level, String categoryName, String configName) {
        if (!(subsystemDesc instanceof ASubsystemDescription)) {
            throw new IllegalArgumentException("deprecated Description");
        }
        return Factories.createConfigProfile((ASubsystemDescription)subsystemDesc, userName, level, categoryName, configName);
    }

    static AConfigProfile createConfigProfile(ASubsystemDescription subsystemDesc, String userName, int level, String categoryName, String configName) {
        AConfigProfile res = new AConfigProfile(subsystemDesc, userName, level, categoryName, configName);
        return res;
    }

    public static ConfigProfile copyProfile(ConfigProfile toBeCopied, String newName, String newUserName, int newLevel, boolean toEngineering) {
        if (toBeCopied instanceof AConfigProfile) {
            return new AConfigProfile((AConfigProfile)toBeCopied, newUserName, newLevel, toEngineering, newName);
        }
        if (toEngineering) {
            throw new IllegalArgumentException("cannot create an engineering profile from a deprecated one");
        }
        throw new UnsupportedOperationException("copy with deprecated profile not yet implemented");
    }

    public static ConfigProfile copyProfileForRegistration(ConfigProfile toBeCopied, String newName, String userName, int newLevel, boolean getRidOfStaticParameters) {
        ConfigProfile res = Factories.copyProfile(toBeCopied, newName, userName, newLevel, false);
        if (getRidOfStaticParameters) {
            for (ParameterConfiguration parameterConfiguration : res.getModifiedParameters()) {
                if (!parameterConfiguration.changingStaticData) continue;
                res.removeParameterConfigurations(parameterConfiguration);
            }
            res.setChangingStaticData(false);
        }
        return res;
    }

    public static ParameterConfiguration createParameterConfiguration(ParameterDescription description, String value) {
        if (!(description instanceof AParameterDescription)) {
            throw new IllegalArgumentException("deprecated description");
        }
        if (description.getId() == 0L) {
            throw new IllegalArgumentException("ParameterDescription not registered in base" + description);
        }
        return new AParameterConfiguration((AParameterDescription)description, value, true);
    }

    public static ParameterConfiguration createParameterConfiguration(ParameterDescription description) {
        if (!(description instanceof AParameterDescription)) {
            throw new IllegalArgumentException("deprecated description");
        }
        if (description.getId() == 0L) {
            throw new IllegalArgumentException("ParameterDescription not registered in base" + description);
        }
        return new AParameterConfiguration((AParameterDescription)description);
    }

    public static ConfigProfile repair(ConfigProfile oldProfile, SubsystemDescription newDescription, ConfigurationMismatchListener mismatchListener) {
        return null;
    }
}

