package org.lsst.ccs.config;

import org.lsst.gruth.jutils.DescriptiveNode;

import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Lob;
import java.io.Serializable;
import java.util.Map;
import org.lsst.gruth.jutils.HollowParm;

/**
 * Contains a "ready to use" component node that results from the merging
 * of default description data with data modified by a configuration
 * TODO : reassess the need or use of this data
 * 
 * @author
 */
@Entity
public class PreparedConfiguration implements Serializable {
    private static final long serialVersionUID = -6386284584439938312L;
    @EmbeddedId
    private NamesAndTag nameAndTag = new NamesAndTag() ;
    private boolean fromProfile ;
    private String user ;
    @Lob // tinyLOb!
    private DescriptiveNode configuredData ;

    //TODO: add deployment descriptors
    /////////////////////////////////// CONSTRUCTORS

    PreparedConfiguration() {
    }

    public PreparedConfiguration(String namedReference, String tag, String subsystemName, String user, boolean fromProfile,
                                 DescriptiveNode configuredData) {
        this.nameAndTag.setConfigName(namedReference);
        this.nameAndTag.setTag(tag);
        this.nameAndTag.setSubsystemName(subsystemName);
        this.user = user ;
        this.fromProfile = fromProfile;
        this.configuredData = configuredData;
    }

    public PreparedConfiguration(ConfigProfile profile) {
        this.nameAndTag.setConfigName(profile.getName());
        this.nameAndTag.setTag(profile.getTag());
        this.nameAndTag.setSubsystemName(profile.getSubsystemDescription().getSubsystemName());
        this.user = profile.getUserName() ;
        this.fromProfile = true;
        // REVIEW : is cast safe ?
        DescriptiveNode configuredData = getModifiedConfigurationData((AConfigProfile) profile);
        this.configuredData = configuredData;

    }

    //////////////////////////////// ACCESSORS/MUTATORS

    public boolean isFromProfile() {
        return fromProfile;
    }

     void setFromProfile(boolean fromProfile) {
        this.fromProfile = fromProfile;
    }


    public DescriptiveNode getConfiguredData() {
        return configuredData;
    }

     void setConfiguredData(DescriptiveNode configuredData) {
        this.configuredData = configuredData;
    }

    public String getSubsystemName() {
        return nameAndTag.getSubsystemName();
    }


    public NamesAndTag getNameAndTag() {
        return nameAndTag;
    }

    void setNameAndTag(NamesAndTag nameAndTag) {
        this.nameAndTag = nameAndTag;
    }

    public String getUser() {
        return user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getConfigName() {
        return nameAndTag.getConfigName() ;
    }

    public String getTag() {
        return nameAndTag.getTag() ;
    }
    
     /**
     * prepares a new executable configuration data with these modified parameters.
     * used by <TT>PreparedConfiguration</TT> objects.
     *
     * @return
     */
    private final DescriptiveNode getModifiedConfigurationData(AConfigProfile profile) {
        DescriptiveNode res = null;
        DescriptiveNode componentNode = profile.getSubsystemDescription().getTopComponentNode() ;
        componentNode = componentNode.clone();
        for (AParameterConfiguration parameterConfiguration : profile.getParameterConfigurations()) {
            ParameterPath path = parameterConfiguration.getPath();
            String componentName = path.getComponentName();
            String codeName = path.getCodeName();
            if (codeName != null && !"".equals(codeName)) {
                throw new UnsupportedOperationException(" no change on methods yet --> " + codeName);
            }
            String parameterName = path.getParameterName();
            DescriptiveNode goalComponent = (DescriptiveNode) componentNode.getNodeByName(componentName);
            if(goalComponent == null) {
                throw new IllegalArgumentException("no component for name :" + componentName) ;
            }
            Map mapAttributes = goalComponent.getAttributes() ;
            // not null
            if(mapAttributes == null ) {
                throw new  IllegalArgumentException("incompatible attribute list for component/parameter " +componentName +"/" +parameterName) ;
            }
            // get Parameter
            Object rawParm = mapAttributes.get(parameterName);
            if (rawParm instanceof HollowParm) {
                HollowParm hollow = (HollowParm) rawParm;
                hollow.modifyChecked(parameterConfiguration.getConfiguredValue());
            } else {
                throw new IllegalArgumentException("parameter not modifiable" + rawParm);
            }
        }
        res = componentNode;

        return res;
    }
}
