/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.Serializable;
import java.util.Map;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Lob;
import org.lsst.ccs.config.AConfigProfile;
import org.lsst.ccs.config.AParameterConfiguration;
import org.lsst.ccs.config.ConfigProfile;
import org.lsst.ccs.config.NamesAndTag;
import org.lsst.ccs.config.ParameterPath;
import org.lsst.gruth.jutils.DescriptiveNode;
import org.lsst.gruth.jutils.HollowParm;

@Entity
public class PreparedConfiguration
implements Serializable {
    private static final long serialVersionUID = -6386284584439938312L;
    @EmbeddedId
    private NamesAndTag nameAndTag = new NamesAndTag();
    private boolean fromProfile;
    private String user;
    @Lob
    private DescriptiveNode configuredData;

    PreparedConfiguration() {
    }

    public PreparedConfiguration(String namedReference, String tag, String subsystemName, String user, boolean fromProfile, DescriptiveNode configuredData) {
        this.nameAndTag.setConfigName(namedReference);
        this.nameAndTag.setTag(tag);
        this.nameAndTag.setSubsystemName(subsystemName);
        this.user = user;
        this.fromProfile = fromProfile;
        this.configuredData = configuredData;
    }

    public PreparedConfiguration(ConfigProfile profile) {
        DescriptiveNode configuredData;
        this.nameAndTag.setConfigName(profile.getName());
        this.nameAndTag.setTag(profile.getTag());
        this.nameAndTag.setSubsystemName(profile.getSubsystemDescription().getSubsystemName());
        this.user = profile.getUserName();
        this.fromProfile = true;
        this.configuredData = configuredData = this.getModifiedConfigurationData((AConfigProfile)profile);
    }

    public boolean isFromProfile() {
        return this.fromProfile;
    }

    void setFromProfile(boolean fromProfile) {
        this.fromProfile = fromProfile;
    }

    public DescriptiveNode getConfiguredData() {
        return this.configuredData;
    }

    void setConfiguredData(DescriptiveNode configuredData) {
        this.configuredData = configuredData;
    }

    public String getSubsystemName() {
        return this.nameAndTag.getSubsystemName();
    }

    public NamesAndTag getNameAndTag() {
        return this.nameAndTag;
    }

    void setNameAndTag(NamesAndTag nameAndTag) {
        this.nameAndTag = nameAndTag;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getConfigName() {
        return this.nameAndTag.getConfigName();
    }

    public String getTag() {
        return this.nameAndTag.getTag();
    }

    private final DescriptiveNode getModifiedConfigurationData(AConfigProfile profile) {
        DescriptiveNode res = null;
        DescriptiveNode componentNode = profile.getSubsystemDescription().getTopComponentNode();
        componentNode = componentNode.clone();
        for (AParameterConfiguration parameterConfiguration : profile.getParameterConfigurations()) {
            ParameterPath path = parameterConfiguration.getPath();
            String componentName = path.getComponentName();
            String codeName = path.getCodeName();
            if (codeName != null && !"".equals(codeName)) {
                throw new UnsupportedOperationException(" no change on methods yet --> " + codeName);
            }
            String parameterName = path.getParameterName();
            DescriptiveNode goalComponent = (DescriptiveNode)componentNode.getNodeByName(componentName);
            if (goalComponent == null) {
                throw new IllegalArgumentException("no component for name :" + componentName);
            }
            Map mapAttributes = goalComponent.getAttributes();
            if (mapAttributes == null) {
                throw new IllegalArgumentException("incompatible attribute list for component/parameter " + componentName + "/" + parameterName);
            }
            Object rawParm = mapAttributes.get(parameterName);
            if (rawParm instanceof HollowParm) {
                HollowParm hollow = (HollowParm)rawParm;
                hollow.modifyChecked((Object)parameterConfiguration.getValue());
                continue;
            }
            throw new IllegalArgumentException("parameter not modifiable" + rawParm);
        }
        res = componentNode;
        return res;
    }
}

