/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.config.NamesAndTag;
import org.lsst.ccs.config.utilities.ConfigUtils;

public class ConfigurationFileNameTest {
    @Test
    public void testConfigFileNames() {
        System.setProperty("org.lsst.ccs.newfilenaming", "false");
        String configPath = null;
        NamesAndTag nat = ConfigUtils.namesFromPaths((String)"/some/path/subsystem.groovy", configPath);
        Assert.assertEquals((String)"configuration file name ", (Object)"subsystem", (Object)ConfigUtils.baseNameFromNames((NamesAndTag)nat));
        configPath = "/some/path/subsystem_config.properties";
        nat = ConfigUtils.namesFromPaths((String)"/some/path/subsystem.groovy", (String)configPath);
        Assert.assertEquals((String)"configuration file name ", (Object)configPath, (Object)ConfigUtils.baseNameFromNames((String)nat.getSubsystemName(), (String)configPath, (String)nat.getTag()));
        nat = ConfigUtils.namesFromPaths((String)"subsystem.groovy", null);
        Assert.assertEquals((String)"configuration file name ", (Object)"subsystem", (Object)ConfigUtils.baseNameFromNames((NamesAndTag)nat));
        nat = ConfigUtils.namesFromPaths((String)"subsystem_config.groovy", null);
        Assert.assertEquals((String)"configuration file name ", (Object)"subsystem_config", (Object)ConfigUtils.baseNameFromNames((NamesAndTag)nat));
        nat = ConfigUtils.namesFromPaths((String)"subsystem.groovy", (String)"config");
        Assert.assertEquals((String)"configuration file name ", (Object)"subsystem_config", (Object)ConfigUtils.baseNameFromNames((NamesAndTag)nat));
        nat = ConfigUtils.namesFromPaths((String)"subsystem__tag.groovy", (String)"config");
        Assert.assertEquals((String)"configuration file name ", (Object)"subsystem_config_tag", (Object)ConfigUtils.baseNameFromNames((NamesAndTag)nat));
        nat = ConfigUtils.namesFromPaths((String)"subsystem__tag.groovy", null);
        Assert.assertEquals((String)"configuration file name ", (Object)"subsystem__tag", (Object)ConfigUtils.baseNameFromNames((NamesAndTag)nat));
        nat = ConfigUtils.namesFromPaths((String)"subsystem_config_tag.groovy", null);
        Assert.assertEquals((String)"configuration file name ", (Object)"subsystem_config_tag", (Object)ConfigUtils.baseNameFromNames((NamesAndTag)nat));
        System.setProperty("org.lsst.ccs.newfilenaming", "true");
        nat = ConfigUtils.namesFromPaths((String)"/some/path/somename", null);
        Assert.assertEquals((String)"configuration file name ", (Object)"somename", (Object)ConfigUtils.baseNameFromNames((NamesAndTag)nat));
        configPath = "/some/path/somename_config.properties";
        nat = ConfigUtils.namesFromPaths((String)"/some/path/somename", (String)configPath);
        Assert.assertEquals((String)"configuration file name ", (Object)configPath, (Object)ConfigUtils.baseNameFromNames((String)nat.getSubsystemName(), (String)configPath, (String)nat.getTag()));
        nat = ConfigUtils.namesFromPaths((String)"somename", (String)"config");
        Assert.assertEquals((String)"configuration file name ", (Object)"somename_config", (Object)ConfigUtils.baseNameFromNames((NamesAndTag)nat));
    }
}

