/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.config.NamesAndTag;
import org.lsst.ccs.config.utilities.ConfigUtils;

public class ConfigurationFileNameTest {
    @Test
    public void testConfigFileNames() {
        System.setProperty("org.lsst.ccs.newfilenaming", "false");
        NamesAndTag nat = ConfigUtils.namesFromPaths((String)"/some/path/subsystem.groovy", null);
        Assert.assertEquals((String)"configuration file name ", (Object)"subsystem", (Object)nat.getConfigPath());
        nat = ConfigUtils.namesFromPaths((String)"/some/path/subsystem.groovy", (String)"/some/path/subsystem_config.properties");
        Assert.assertEquals((String)"configuration file name ", (Object)"/some/path/subsystem_config.properties", (Object)nat.getConfigPath());
        nat = ConfigUtils.namesFromPaths((String)"subsystem.groovy", null);
        Assert.assertEquals((String)"configuration file name ", (Object)"subsystem", (Object)nat.getConfigPath());
        nat = ConfigUtils.namesFromPaths((String)"subsystem_config.groovy", null);
        Assert.assertEquals((String)"configuration file name ", (Object)"subsystem_config", (Object)nat.getConfigPath());
        nat = ConfigUtils.namesFromPaths((String)"subsystem.groovy", (String)"config");
        Assert.assertEquals((String)"configuration file name ", (Object)"subsystem_config", (Object)nat.getConfigPath());
        nat = ConfigUtils.namesFromPaths((String)"subsystem__tag.groovy", (String)"config");
        Assert.assertEquals((String)"configuration file name ", (Object)"subsystem_config_tag", (Object)nat.getConfigPath());
        nat = ConfigUtils.namesFromPaths((String)"subsystem__tag.groovy", null);
        Assert.assertEquals((String)"configuration file name ", (Object)"subsystem__tag", (Object)nat.getConfigPath());
        nat = ConfigUtils.namesFromPaths((String)"subsystem_config_tag.groovy", null);
        Assert.assertEquals((String)"configuration file name ", (Object)"subsystem_config_tag", (Object)nat.getConfigPath());
        System.setProperty("org.lsst.ccs.newfilenaming", "true");
        nat = ConfigUtils.namesFromPaths((String)"/some/path/somename", null);
        Assert.assertEquals((String)"configuration file name ", (Object)"somename", (Object)nat.getConfigPath());
        nat = ConfigUtils.namesFromPaths((String)"/some/path/somename", (String)"/some/path/somename_config.properties");
        Assert.assertEquals((String)"configuration file name ", (Object)"/some/path/somename_config.properties", (Object)nat.getConfigPath());
        nat = ConfigUtils.namesFromPaths((String)"somename", (String)"config");
        Assert.assertEquals((String)"configuration file name ", (Object)"somename_config", (Object)nat.getConfigPath());
    }
}

