package org.lsst.ccs.config;

import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import java.io.Serializable;
import java.util.List;

/**
 * abstract class for all parameter configurations
 * @author bamade
 */
// Date: 11/04/12

    @MappedSuperclass
public abstract class ParameterConfiguration  implements Serializable, PathObject{
    //TODO : a list of ValueEvent object start, (next?)
    protected String value ;

    /**
     * tells us if this configuration can be operated at runTime or not
     */
    protected boolean changingStaticData ;

    /**
     * this transient field is to carry information about a failure in configuration "repair".
     * The corresponding parameter cannot be matched to a new <TT>SubsystemDescription</TT>
     * to which we try to attach this (possibly deprecated) Configuration.
     */
    @Transient
    protected Exception reConfigurationFailure ;


    ///////////////////////// CONSTRUCTORS

    protected ParameterConfiguration() {

    }
    protected ParameterConfiguration(String value) {
        this.value = value;
    }


    /////////////////////////// ACCESSORS/MUTATORS

    public abstract long getId() ;
    protected abstract void setId(long id) ;

    public boolean isReadOnly() {
        return getId() != 0L ;
    }

    public Exception getReConfigurationFailure() {
        return reConfigurationFailure;
    }

    public void setReConfigurationFailure(Exception reConfigurationFail) {
        this.reConfigurationFailure = reConfigurationFail;
    }

    public abstract ParameterDescription getDescription() ;

    public abstract List<? extends ValueEvent> getValueEvents() ;

    // public abstract void addValueEvent(ValueEvent event) ;

    public String getValue() {
        return value;
    }
    void setValue(String value) {
        /* if( isReadOnly()) {
            throw new ImmutableStateException("read only value") ;
        } */
        this.value = value;
    }

    public boolean isChangingStaticData() {
        return changingStaticData;
    }

    void setChangingStaticData(boolean changingStaticData) {
        this.changingStaticData = changingStaticData;
    }

    public Object checkValue(String value) throws IllegalArgumentException{
        ParameterDescription description = this.getDescription();
        return description.checkValue(value) ;
        /*
        return Constraints.check(description.getParameterBase().getTypeName(),
                value, description.getConstraints()) ;
        */
    }

    /**
     * the value is modifiable only on objects not yet registered in the database
     * @param value
     * @throws ImmutableStateException if modification is for a registered object
     * @throws IllegalArgumentException if value is not coherent with type and constraints
     */
    public void modifyValue(String value) {
        if( isReadOnly()) {
            throw new ImmutableStateException("read only value") ;
        }

        /* NOT CORRECT : this can be modified when the system is not running!
        if(this.getDescription().isNotModifiableAtRuntime()) {
            throw new ImmutableStateException("static value " + value + " cannot be modified  at runtime") ;
        } */
        if(checkValue(value) != null) {
            setValue(value);
        }
    }

    /**
     * method for two phases commit: call only if check is ok.
     * @param value
     */
    public void modifyValueAfterCheck(String value) {
        if( isReadOnly()) {
            throw new ImmutableStateException("read only value") ;
        }
        setValue(value);
    }
    ///////////////////////////// IDENT METHODS
    // TODO: add id?

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof PathObject)) return false;

        PathObject that = (PathObject) o;
        ParameterDescription description = getDescription();
        if (!description.getPath().equals(that.getPath())) return false;

        return true;
    }

    @Override
    public String toString() {
        return  this.getId() + "{" + getId() +
                ": description=" + getDescription() +
                ", value='" + value + '\'' +
                '}';
    }

    @Override
    public int hashCode() {
        return getDescription().hashCode();
    }

    @Override
    public ParameterPath getPath() {
        return getDescription().getPath();
    }
}
