/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config.utilities;

import org.lsst.ccs.config.NamesAndTag;

public class ConfigUtils {
    public static NamesAndTag namesFromPath(String pathName) {
        String subsystemName = "";
        String configName = "";
        String tag = "";
        if (ConfigUtils.isAPath(pathName)) {
            int indexDot = pathName.lastIndexOf(46);
            int lastPath = pathName.lastIndexOf(47);
            String rawName = pathName.substring(lastPath + 1, indexDot);
            String[] elements = rawName.split("_");
            switch (elements.length) {
                case 3: {
                    tag = elements[2];
                }
                case 2: {
                    configName = elements[1];
                }
                case 1: {
                    subsystemName = elements[0];
                }
            }
            return new NamesAndTag(subsystemName, configName, tag);
        }
        configName = pathName;
        return new NamesAndTag(subsystemName, configName, tag);
    }

    public static NamesAndTag namesFromPaths(String descriptionPathName, String configurationPathName) {
        NamesAndTag descNT = ConfigUtils.namesFromPath(descriptionPathName);
        String subsystemName = descNT.getSubsystemName();
        String configName = descNT.getConfigName();
        String tagName = descNT.getTag();
        if (configurationPathName != null) {
            NamesAndTag confNT = ConfigUtils.namesFromPath(configurationPathName);
            if (!confNT.getSubsystemName().isEmpty() && !subsystemName.equals(confNT.getSubsystemName())) {
                throw new IllegalArgumentException(" subsystem names differs :" + subsystemName + " <> " + confNT.getSubsystemName());
            }
            String newConfigName = confNT.getConfigName();
            if (configName.length() != 0 && newConfigName.length() != 0 && !configName.equals(newConfigName)) {
                throw new IllegalArgumentException(" configuration name clash :" + configName + " <> " + newConfigName);
            }
            if (newConfigName.length() != 0) {
                configName = newConfigName;
            }
            String newTagName = confNT.getTag();
            if (tagName.length() != 0 && newTagName.length() != 0 && !descNT.getTag().equals(newTagName)) {
                throw new IllegalArgumentException(" tag name clash :" + tagName + " <> " + newTagName);
            }
            if (newTagName.length() != 0) {
                tagName = newTagName;
            }
        }
        String configPath = ConfigUtils.isAPath(configurationPathName) ? configurationPathName : ConfigUtils.baseNameFromNames(subsystemName, configName, tagName);
        return new NamesAndTag(subsystemName, configName, tagName, configPath);
    }

    public static String baseNameFromNames(NamesAndTag namesAndTag) {
        return ConfigUtils.baseNameFromNames(namesAndTag.getSubsystemName(), namesAndTag.getConfigName(), namesAndTag.getTag());
    }

    public static String baseNameFromNames(String subsystemName, String configName, String tagName) {
        String baseName = subsystemName;
        if (configName.isEmpty()) {
            if (!tagName.isEmpty()) {
                baseName = String.valueOf(baseName) + "__" + tagName;
            }
        } else {
            baseName = String.valueOf(baseName) + "_" + configName;
            if (!tagName.isEmpty()) {
                baseName = String.valueOf(baseName) + "_" + tagName;
            }
        }
        return baseName;
    }

    public static boolean isAPath(String string) {
        int lastPath;
        if (string == null) {
            return false;
        }
        int lastDot = string.lastIndexOf(".");
        return lastDot > (lastPath = string.lastIndexOf("/"));
    }
}

