/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Optional;
import java.util.Properties;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.MessagingFactory;
import org.lsst.ccs.config.AConfigProfile;
import org.lsst.ccs.config.ASubsystemDescription;
import org.lsst.ccs.config.ConfigProfile;
import org.lsst.ccs.config.Constraints;
import org.lsst.ccs.config.ParameterDescription;
import org.lsst.ccs.config.ParameterPath;
import org.lsst.ccs.config.SubsystemDescription;
import org.lsst.ccs.config.utilities.ConfigUtils;
import org.lsst.ccs.framework.ConfigurationProxy;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.structs.ViewValue;
import org.lsst.gruth.types.TypeUtils;

public class LocalConfigurationProxy
implements ConfigurationProxy {
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private ASubsystemDescription subsystemDescription;
    private AConfigProfile baseProfile;
    private AConfigProfile currentProfile;
    private volatile boolean configurationContextStarted;
    private Subsystem actualSubsystem;
    private MessagingFactory fac;
    Logger logger = Logger.getLogger((String)"org.lsst.ccs.config");
    private WriterProvider writerProvider = new WriterProvider(){

        @Override
        public PrintWriter getPrintWriter(String baseName) throws IOException {
            String pathInBootstrap = BootstrapResourceUtils.getPathOfPropertiesFileInUserResourceDirectories((String)baseName);
            if (pathInBootstrap == null) {
                String topMostUserDirectory = BootstrapResourceUtils.getTopUserResourceDirectory();
                if (topMostUserDirectory == null) {
                    String workdir = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.workdir", "");
                    if (!workdir.isEmpty() && !workdir.endsWith(FILE_SEPARATOR)) {
                        workdir = String.valueOf(workdir) + FILE_SEPARATOR;
                    }
                    baseName = String.valueOf(workdir) + baseName;
                } else {
                    baseName = String.valueOf(topMostUserDirectory) + baseName;
                }
            } else {
                baseName = pathInBootstrap;
            }
            if (!baseName.endsWith(".properties")) {
                baseName = String.valueOf(baseName) + ".properties";
            }
            LocalConfigurationProxy.this.logger.info((Object)("Saving configuration  to " + baseName), new String[0]);
            PrintWriter printWriter = new PrintWriter(baseName, "ISO-8859-1");
            return printWriter;
        }

        @Override
        public Properties getConfigurationProperties(String configFileName) throws IOException {
            if (!configFileName.endsWith(".properties")) {
                configFileName = String.valueOf(configFileName) + ".properties";
            }
            Properties configProps = new Properties();
            InputStream propsIs = BootstrapResourceUtils.getBootstrapResource((String)configFileName);
            if (propsIs == null) {
                throw new IllegalArgumentException("Could not find configuration file : " + configFileName);
            }
            configProps.load(propsIs);
            return configProps;
        }
    };

    public LocalConfigurationProxy(SubsystemDescription subsystemDesc) {
        this.subsystemDescription = (ASubsystemDescription)subsystemDesc;
    }

    public LocalConfigurationProxy(ConfigProfile configProfile) {
        this.baseProfile = (AConfigProfile)configProfile;
        this.subsystemDescription = this.baseProfile.getSubsystemDesc();
    }

    boolean isInEngineeringMode() {
        if (this.actualSubsystem == null) {
            return false;
        }
        return this.actualSubsystem.isInEngineeringMode();
    }

    public synchronized String getConfigurationName() {
        return this.currentProfile.getName();
    }

    public synchronized String getTagName() {
        return this.currentProfile.getTag();
    }

    public synchronized void startNewConfigurationContext() {
        if (!this.isInEngineeringMode()) {
            throw new IllegalStateException("not in engineering mode");
        }
        if (this.configurationContextStarted) {
            return;
        }
        this.configurationContextStarted = true;
        this.currentProfile = new AConfigProfile(this.baseProfile, this.baseProfile.getName(), "", 10, true);
    }

    public ViewValue checkForParameterChange(String componentName, String parameterName, Object value) {
        ParameterPath path;
        ParameterDescription parameterDescription;
        String strValue = value instanceof String ? (String)value : TypeUtils.stringify((Object)value);
        if (!this.configurationContextStarted) {
            this.startNewConfigurationContext();
        }
        if ((parameterDescription = this.subsystemDescription.fetch(path = new ParameterPath(componentName, "", parameterName))) == null) {
            throw new IllegalArgumentException("incoherent parameter name for " + parameterName + "-> " + this.subsystemDescription.getSubsystemName());
        }
        if (parameterDescription.isNotModifiableAtRuntime()) {
            throw new IllegalStateException(" parameter " + parameterName + " not modifiable at runtime");
        }
        Object res = parameterDescription.checkValue(strValue);
        return new ViewValue(strValue, res);
    }

    public synchronized void notifyParameterChange(String componentName, String parameterName, String value) {
        ParameterPath path = new ParameterPath(componentName, "", parameterName);
        this.currentProfile.temporaryChangeConfigurationValue(path.toString(), System.currentTimeMillis(), value, true);
    }

    public synchronized void notifyUncheckedParameterChange(String componentName, String parameterName, Object value) {
        ParameterPath path = new ParameterPath(componentName, "", parameterName);
        String strValue = value instanceof String ? (String)value : TypeUtils.stringify((Object)value);
        this.currentProfile.temporaryChangeConfigurationValue(path.toString(), System.currentTimeMillis(), strValue, false);
    }

    public synchronized void registerConfiguration(String configurationName) throws IOException {
        this.registerConfiguration(configurationName, null);
    }

    public synchronized void registerConfiguration(String configurationName, String tagName) throws IOException {
        if (ConfigUtils.isAPath(configurationName)) {
            throw new IllegalArgumentException("registerConfiguration requires a configuration name, not a path");
        }
        if (tagName != null && !tagName.equals(this.subsystemDescription.getTag())) {
            throw new IllegalArgumentException("tag of configuration and of subsystem should be the same");
        }
        if (!this.configurationContextStarted) {
            return;
        }
        this.saveModifications(configurationName);
        PrintWriter printWriter = this.writerProvider.getPrintWriter(ConfigUtils.baseNameFromNames(this.subsystemDescription.getSubsystemName(), configurationName, this.subsystemDescription.getTag()));
        this.currentProfile.generateConfigProperties(printWriter);
        this.configurationContextStarted = false;
        printWriter.flush();
        printWriter.close();
    }

    public synchronized void saveModifications(String configurationName) {
        if (!this.configurationContextStarted) {
            return;
        }
        this.baseProfile = new AConfigProfile(this.currentProfile, configurationName, "", 10, false);
        this.currentProfile = this.baseProfile.clone();
        this.configurationContextStarted = false;
    }

    public synchronized void dropModifications() {
        this.currentProfile = this.baseProfile.clone();
        this.configurationContextStarted = false;
    }

    public Object getDefaultParameterValue(String componentName, String parameterName) {
        ParameterPath path = new ParameterPath(componentName, "", parameterName);
        ParameterDescription parameterDescription = this.subsystemDescription.fetch(path);
        String strValue = parameterDescription.getDefaultValue();
        String type = parameterDescription.getTypeName();
        Object res = Constraints.check(type, strValue, null);
        return res;
    }

    public void setSubsystem(Subsystem subsystem) {
        this.actualSubsystem = subsystem;
        this.fac = subsystem.getMessagingAccess();
    }

    public Optional<Subsystem> getSubsystem() {
        return Optional.ofNullable(this.actualSubsystem);
    }

    public AConfigProfile getBaseProfile() {
        return this.baseProfile;
    }

    public void setBaseProfile(ConfigProfile profile) {
        this.baseProfile = (AConfigProfile)profile;
    }

    public void setWriterProvider(WriterProvider writerProvider) {
        this.writerProvider = writerProvider;
    }

    public WriterProvider getWriterProvider() {
        return this.writerProvider;
    }

    public static interface WriterProvider {
        public PrintWriter getPrintWriter(String var1) throws IOException;

        public Properties getConfigurationProperties(String var1) throws IOException;
    }
}

