/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Scanner;
import org.lsst.ccs.config.AConfigProfile;
import org.lsst.ccs.config.AParameterConfiguration;
import org.lsst.ccs.config.AParameterDescription;
import org.lsst.ccs.config.ASubsystemDescription;
import org.lsst.ccs.config.ConfigProfile;
import org.lsst.ccs.config.ConfigurationMismatchListener;
import org.lsst.ccs.config.DataFlavour;
import org.lsst.ccs.config.DescriptionMismatchListener;
import org.lsst.ccs.config.ParameterBase;
import org.lsst.ccs.config.ParameterConfiguration;
import org.lsst.ccs.config.ParameterDescription;
import org.lsst.ccs.config.ParameterFilter;
import org.lsst.ccs.config.SubsystemDescription;

public class Factories {
    public static SubsystemDescription createRawSubsystemDescription(String subsystemName, String tag, String user, String version, Serializable configurationData, DataFlavour dataFlavour) {
        return new ASubsystemDescription(subsystemName, tag, user, version, configurationData, dataFlavour);
    }

    public static SubsystemDescription createRawSubsystemDescription(String subsystemName, String tag, String user, String version, InputStream inputStream, String charSetName) {
        String text = new Scanner(inputStream, charSetName).useDelimiter("\\A").next();
        return new ASubsystemDescription(subsystemName, tag, user, version, (Serializable)((Object)text), DataFlavour.TREE_FROM_SOURCE);
    }

    public static SubsystemDescription createSubsystemDescription(String subsystemName, String tag, String user, String version, Serializable configurationData, DataFlavour dataFlavour, ParameterFilter filter) {
        ASubsystemDescription res = new ASubsystemDescription(subsystemName, tag, user, version, configurationData, dataFlavour);
        Collection<ParameterDescription> descriptions = res.getPossibleDescriptions(10, filter);
        for (ParameterDescription description : descriptions) {
            res.addParameterDescriptions(description);
        }
        return res;
    }

    public static SubsystemDescription createSubsystemDescriptionCopy(SubsystemDescription desc) {
        return new ASubsystemDescription(desc);
    }

    public static ParameterDescription createParameterDescription(ParameterBase parameterBase, String description, String simpleName, String constraints, int level) {
        return new AParameterDescription(parameterBase, description, simpleName, constraints, level);
    }

    public static ParameterDescription createParameterDescription(ParameterDescription other) {
        return new AParameterDescription(other);
    }

    public static void tryCopyParameters(SubsystemDescription newDescription, SubsystemDescription model, DescriptionMismatchListener mismatchListener) {
        System.err.println("Try copy Parameters not implemented yet");
    }

    public static ConfigProfile createRawConfigProfile(SubsystemDescription subsystemDesc, String name, String tag, String userName, int level) {
        if (!(subsystemDesc instanceof ASubsystemDescription)) {
            throw new IllegalArgumentException("deprecated Description");
        }
        return Factories.createRawConfigProfile((ASubsystemDescription)subsystemDesc, name, userName, level);
    }

    static AConfigProfile createRawConfigProfile(ASubsystemDescription subsystemDesc, String name, String userName, int level) {
        return new AConfigProfile(subsystemDesc, name, userName, level);
    }

    public static ConfigProfile createConfigProfile(SubsystemDescription subsystemDesc, String name, String tag, String userName, int level) {
        if (!(subsystemDesc instanceof ASubsystemDescription)) {
            throw new IllegalArgumentException("deprecated Description");
        }
        return Factories.createConfigProfile((ASubsystemDescription)subsystemDesc, name, tag, userName, level);
    }

    static AConfigProfile createConfigProfile(ASubsystemDescription subsystemDesc, String name, String tag, String userName, int level) {
        AConfigProfile res = new AConfigProfile(subsystemDesc, name, userName, level);
        return res;
    }

    public static ConfigProfile copyProfile(ConfigProfile toBeCopied, String newName, String newUserName, int newLevel, boolean toEngineering) {
        if (toBeCopied instanceof AConfigProfile) {
            return new AConfigProfile((AConfigProfile)toBeCopied, newName, newUserName, newLevel, toEngineering);
        }
        if (toEngineering) {
            throw new IllegalArgumentException("cannot create an engineering profile from a deprecated one");
        }
        throw new UnsupportedOperationException("copy with deprecated profile not yet implemented");
    }

    public static ConfigProfile copyProfileForRegistration(ConfigProfile toBeCopied, String newName, String userName, int newLevel, boolean getRidOfStaticParameters) {
        ConfigProfile res = Factories.copyProfile(toBeCopied, newName, userName, newLevel, false);
        if (getRidOfStaticParameters) {
            for (ParameterConfiguration parameterConfiguration : res.getModifiedParameters()) {
                if (!parameterConfiguration.changingStaticData) continue;
                res.removeParameterConfigurations(parameterConfiguration);
            }
            res.setChangingStaticData(false);
        }
        return res;
    }

    public static ParameterConfiguration createParameterConfiguration(ParameterDescription description, String value) {
        if (!(description instanceof AParameterDescription)) {
            throw new IllegalArgumentException("deprecated description");
        }
        if (description.getId() == 0L) {
            throw new IllegalArgumentException("ParameterDescription not registered in base" + description);
        }
        return new AParameterConfiguration((AParameterDescription)description, value, true);
    }

    public static ParameterConfiguration createParameterConfiguration(ParameterDescription description) {
        if (!(description instanceof AParameterDescription)) {
            throw new IllegalArgumentException("deprecated description");
        }
        if (description.getId() == 0L) {
            throw new IllegalArgumentException("ParameterDescription not registered in base" + description);
        }
        return new AParameterConfiguration((AParameterDescription)description);
    }

    public static ConfigProfile repair(ConfigProfile oldProfile, SubsystemDescription newDescription, ConfigurationMismatchListener mismatchListener) {
        return null;
    }
}

