package org.lsst.ccs.config;

import org.lsst.gruth.jutils.DescriptiveNode;
import org.lsst.gruth.nodes.Utils;

import java.io.Serializable;

/**
 * Object to store both a text source for a Subsystem description and the binary data extracted
 * from it (type <TT>ComponentNode</TT>)
 * @author bamade
 */
// Date: 20/06/12


public class TextAndNode  implements Serializable {
    private static final long serialVersionUID = -4705364076252108833L;
    String codeSource;
    // todo: should be a DescriptiveNode
    DescriptiveNode componentNode ;

    public TextAndNode(String codeSource, DescriptiveNode componentNode) {
        this.codeSource = codeSource;
        this.componentNode = componentNode;
    }

    public TextAndNode(Object objSource) {
        if(! (objSource instanceof String)) {
            throw new IllegalArgumentException("TextAndNode ctor accepts String but is " + objSource.getClass()) ;
        }
        String source = (String) objSource;
        DescriptiveNode node = Utils.getComponentNodeFromGroovy(source) ;
        this.codeSource = source ;
        this.componentNode = node ;
    }


    public String getCodeSource() {
        return codeSource;
    }

     void setCodeSource(String codeSource) {
        this.codeSource = codeSource;
    }

    public DescriptiveNode getComponentNode() {
        return componentNode;
    }

     void setComponentNode(DescriptiveNode componentNode) {
        this.componentNode = componentNode;
    }
}
