package org.lsst.ccs.config;

import java.util.Comparator;

/**
 * Two objects with the same ParameterPath are unique in their category.
 * The method would be used to fetch an object in a <TT>Set</TT>
 * using another <TT>PathObject</TT>
 * <P/>
 * Important note: these comparisons are not related to any order in parameters (for instance
 * order in the tree of components).
 */
public interface PathObject {
    public static final Comparator<PathObject> COMPARATOR = new Comparator<PathObject>() {
        @Override
        public int compare(PathObject pathObject, PathObject otherPathObject) {
            String pathString = pathObject.getPath().toString() ;
            String otherPathString = otherPathObject.getPath().toString() ;
            if(pathString.startsWith("main/") && ! otherPathString.startsWith("main/")) {
                return -1 ;
            }
            if(otherPathString.startsWith("main/") && ! pathString.startsWith("main/")) {
                return 1 ;
            }
            return pathString.compareTo(otherPathString);
        }
    } ;
    public ParameterPath getPath() ;

}
