package org.lsst.ccs.config;

import groovy.util.Eval;
import org.apache.commons.beanutils.MethodUtils;
import org.lsst.gruth.types.IncompatibleTypeException;
import org.lsst.gruth.jutils.SStructParm;
import org.lsst.gruth.types.GArray;
import org.lsst.gruth.types.GStruct;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;

/**
 * A set of static methods to check constraints.
 * @ImplNote
 * since this class depends heavily on Groovy it must be moved to gruth package.
 * @author bamade
 */
// Date: 31/05/12

public class Constraints {
    /**
     * A specific code to control a value.
     * instance of this class are supposed to have a no-arg constructor.
     */
    public static interface Controler {
        /**
         * should transform the String argument as a valid value and check it.
         * @param value
         * @returna the correct object or throws an exception
         */
        public Object control(String value);
    }

    public static Object check (String type, String value , String constraints) {
        Object realValue = null ;
        type = type.trim() ;
        //TODO: whatif value == null or "".equals(value) ?
        value = value.trim() ;
        if(constraints != null) {
            constraints = constraints.trim() ;
            if(! "".equals(constraints)) {
                return checkConstraints(type, value, constraints) ;
            }
        }
        // TODO: following code to be separated to be used by predicates (see below)
        Class thatClass = null;
        try {
            thatClass = Class.forName(type);
            if(thatClass.isArray()) {
               realValue = GArray.valueOf(value, thatClass.getName()) ;
            } else if (null!= SStructParm.structClassUsesList(thatClass)) {
                realValue = GStruct.valueOf(thatClass, value) ;
            } else {
                realValue = MethodUtils.invokeStaticMethod(thatClass, "valueOf", value);
            }
        } catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        } catch (NoSuchMethodException e) {
            if( Map.class.isAssignableFrom(thatClass)||
                    List.class.isAssignableFrom(thatClass)){
                try {
                    realValue = Eval.me(value) ;
                } catch (Exception exc) {
                    throw new IllegalArgumentException(exc);
                }
                Class realClass = realValue.getClass();
                if(! thatClass.isAssignableFrom(realClass)) {
                    throw new IncompatibleTypeException(thatClass, realClass);
                }
            } else {
                throw new IllegalArgumentException(e);
            }
        } catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        } catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        } catch (Exception exc) {
            return null ;
        }
        return realValue ;

    }

    public static Object checkConstraints(String type, String value, String constraints) {
        //type = type.trim();
        //value = value.trim() ;
        // constraints = constraints.trim() ;
        //is a range
        String[] split = constraints.split("\\.\\.");
        if (split.length == 2) {
            return checkRange(type, value, split[0], split[1]);
        }
        // is a controler or a predicate
        try {
            if(constraints.startsWith("##")) {
                String[] splits = constraints.split("##") ;
                String argName = splits[1] ;
                String expr = splits[2] ;
                Object realValue = check(type,value,"") ;
                Object checks = Eval.me(argName,realValue,expr) ;
                if(checks  instanceof  Boolean) {
                    boolean doIt = ((Boolean)checks).booleanValue();
                    if(doIt) {
                        return realValue ;
                    }
                }
                throw new IllegalArgumentException(" predicate " + expr + " FAILED") ;

            } else {
                Controler controler = (Controler) Class.forName(constraints).newInstance();
                return checkWithControler(value, controler);
            }
        } catch (Exception exc) {
            throw new IllegalArgumentException("constraint :" + constraints + " " + exc);
        }
    }

    /**
     * checks if the value of type  is between lower and upper (included).
     * @param type a Class Name. the class <B>should</B> have a static factory method <TT>valueOf(String val)</TT>
     *             (but <TT>java.lang.Character</TT> is still ok)
     * @param value
     * @param lower
     * @param upper
     * @return
     */
    public static Object checkRange(String type, String value, String lower, String upper) {
        // should have a valueOf method and should yiled a Comparable Object
        Class thatClass = null;
        try {
            //TODO: does not work for Character!
            if("java.lang.Character".equals(type)) {
                type = "java.lang.String" ;
            }
            thatClass = Class.forName(type);
        } catch (Exception exc) {
            throw new IllegalArgumentException(exc);
        }
         return checkRange(thatClass, value, lower, upper) ;

    }

    public static Object checkRange(Class thatClass, String value, String lower, String upper) {
        Object realValue = null ;
        try {
             realValue = MethodUtils.invokeStaticMethod(thatClass, "valueOf", value);
            Object realUpper = MethodUtils.invokeStaticMethod(thatClass, "valueOf", upper);
            Object realLower = MethodUtils.invokeStaticMethod(thatClass, "valueOf", lower);
            Comparable compValue = (Comparable) realValue ;
            if((compValue.compareTo(realLower) >= 0) && (compValue.compareTo(realUpper) <= 0)) {
                return realValue ;
            } else {
               throw new IllegalArgumentException(realValue + "not in range [" +realLower + ".." + realUpper+"]") ;
            }
        } catch (Exception exc) {
            throw new IllegalArgumentException("range " + lower + ".." + upper +
                    " and value :" + value + " raises :" + exc);
        }

    }

    public static Object checkWithControler(String value, Controler controler) {
        return controler.control(value);
    }
}
