package org.lsst.ccs.config;

import org.hibernate.annotations.Immutable;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;

/**
 * Represents an actual parameterDescription. These objects are supposed to be immutable!
 * When willing to change data create a new one using appropriate constructors.
 * @author bamade
 */
// Date: 10/04/12

    @Entity
    @Immutable
//@Table(name="ParmDescription")
 public class AParameterDescription extends ParameterDescription implements Cloneable{
    private static final long serialVersionUID = 918323180559048934L;
    @Id
    @GeneratedValue
    private long id ; //generated

    /////////////////////////// CONSTRUCTORS

    /**
     * convenience constructor for POJO manipulating software, do not use!
     */
    AParameterDescription() {
    }

    /**
     * to be used to create a new Actual ParameterDescription from scratch or from another Actual ParameterDescription
     * (when changing level, or constraints, or simpleName, or description).
     * @param parameterBase
     * @param description
     * @param simpleName
     * @param constraints
     * @param level
     */
    public AParameterDescription(ParameterBase parameterBase, String description, String simpleName, String constraints, int level) {
        super(parameterBase);
        setDescription(description);
        setSimpleName(simpleName);
        setConstraints(constraints);
        setLevel(level);
    }

    /**
     * Creates a new Object from a ParameterDescription but does not copy the id.
     * The id will be generated when the new Object will be inserted in the Database.
     * @param otherDesc
     *
     */
    public AParameterDescription(ParameterDescription otherDesc) {
        this(otherDesc.getParameterBase(), otherDesc.getDescription(), otherDesc.getSimpleName(), otherDesc.getConstraints(), otherDesc.getLevel());
    }

    //////////  ACCESSORS/MUTATORS

    @Override
    public long getId() {
        return id;
    }

    @Override
    protected void setId(long id) {
        this.id = id ;
    }

    /**
     *
     * <P>
     * TODO: no persistence for this for the moment! what for the ghost if modified?
     * @param description
     */
    @Override
    public void setDescription(String description) {
        //TODO add a transient modification boolean checked by the persistence
        super.setDescription(description);
    }

    public AParameterDescription clone() {
        AParameterDescription res = null;
        try {
            res = (AParameterDescription) super.clone();
        } catch (CloneNotSupportedException e) {/*IGNORE*/}
        return res ;
    }
}
