/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.config.AConfigProfile;
import org.lsst.ccs.config.AParameterConfiguration;
import org.lsst.ccs.config.AParameterDescription;
import org.lsst.ccs.config.ASubsystemDescription;
import org.lsst.ccs.config.ConfigProfile;
import org.lsst.ccs.config.DBInterface;
import org.lsst.ccs.config.GhostSubsystemDescription;
import org.lsst.ccs.config.MachineConfiguration;
import org.lsst.ccs.config.PastConfigProfile;
import org.lsst.ccs.config.PreparedConfiguration;
import org.lsst.ccs.config.RunHistory;
import org.lsst.ccs.config.SubsystemDescription;

public class FIleBasedDAO
implements DBInterface {
    long seed;
    long idForSubsystems;
    long idForDescriptions;
    long idForProfiles;
    long idForParmConfig;
    Map<String, SubsystemDescription> descriptionMap;
    Map<String, ConfigProfile> configProfileMap;
    Logger CURLOG;

    public FIleBasedDAO() {
        this.idForSubsystems = this.seed = -System.currentTimeMillis();
        this.idForDescriptions = this.seed;
        this.idForProfiles = this.seed;
        this.idForParmConfig = this.seed;
        this.descriptionMap = new HashMap<String, SubsystemDescription>();
        this.configProfileMap = new HashMap<String, ConfigProfile>();
        this.CURLOG = Logger.getLogger("org.lsst.ccs.config.FIlebasedDAO");
    }

    public FIleBasedDAO(boolean notFromFile) {
        this.idForSubsystems = this.seed = -System.currentTimeMillis();
        this.idForDescriptions = this.seed;
        this.idForProfiles = this.seed;
        this.idForParmConfig = this.seed;
        this.descriptionMap = new HashMap<String, SubsystemDescription>();
        this.configProfileMap = new HashMap<String, ConfigProfile>();
        this.CURLOG = Logger.getLogger("org.lsst.ccs.config.FIlebasedDAO");
    }

    @Override
    public void begin() {
    }

    @Override
    public void end() {
    }

    @Override
    public void fail() {
    }

    @Override
    public void fail(Throwable th) {
        this.CURLOG.log(Level.SEVERE, "file DAO", th);
    }

    @Override
    public void saveSubsystemDescription(ASubsystemDescription newDescription) {
        String subsystemName = newDescription.getSubsystemName();
        String tag = newDescription.getTag();
        newDescription.setId(this.idForSubsystems++);
        for (AParameterDescription parameterDescription : newDescription.getParamDescriptions()) {
            parameterDescription.setId(this.idForDescriptions++);
        }
        this.descriptionMap.put(String.valueOf(subsystemName) + "__" + tag, newDescription);
    }

    @Override
    public void saveGhostDescriptions(GhostSubsystemDescription ghosts) {
        String subsystemName = ghosts.getSubsystemName();
        String tag = ghosts.getTag();
        this.descriptionMap.put("#" + subsystemName + "__" + tag, ghosts);
    }

    @Override
    public ASubsystemDescription getActiveSubsystemDescription(String name, String tag) {
        return (ASubsystemDescription)this.descriptionMap.get(String.valueOf(name) + "__" + tag);
    }

    @Override
    public ASubsystemDescription getActiveSubsystemDescription(long id) {
        for (String key : this.descriptionMap.keySet()) {
            SubsystemDescription description;
            if (key.startsWith("#") || (description = this.descriptionMap.get(key)).getId() != id) continue;
            return (ASubsystemDescription)description;
        }
        return null;
    }

    @Override
    public GhostSubsystemDescription getGhostDescription(long id) {
        for (String key : this.descriptionMap.keySet()) {
            SubsystemDescription description;
            if (!key.startsWith("#") || (description = this.descriptionMap.get(key)).getId() != id) continue;
            return (GhostSubsystemDescription)description;
        }
        return null;
    }

    @Override
    public void deleteActiveSubsystemDescription(ASubsystemDescription oldDescription) {
        String key = String.valueOf(oldDescription.getSubsystemName()) + "__" + oldDescription.getTag();
        this.descriptionMap.remove(key);
    }

    @Override
    public void saveConfigProfile(AConfigProfile newProfile) {
        String key = String.valueOf(newProfile.getSubsystemName()) + "_" + newProfile.getName() + "_" + newProfile.getTag();
        newProfile.setId(this.idForProfiles++);
        for (AParameterConfiguration configuration : newProfile.getParameterConfigurations()) {
            configuration.setId(this.idForParmConfig++);
        }
        this.configProfileMap.put(key, newProfile);
    }

    @Override
    public void savePastProfile(PastConfigProfile deprecatedProfile) {
        String key = "#" + deprecatedProfile.getSubsystemName() + "_" + deprecatedProfile.getName() + "_" + deprecatedProfile.getTag();
        this.configProfileMap.put(key, deprecatedProfile);
    }

    @Override
    public AConfigProfile getActiveConfigProfile(String subsystemName, String name, String tag) {
        return (AConfigProfile)this.configProfileMap.get(String.valueOf(subsystemName) + "_" + name + "_" + tag);
    }

    @Override
    public void deleteActiveConfigProfile(AConfigProfile oldProfile) {
        String key = String.valueOf(oldProfile.getSubsystemName()) + "_" + oldProfile.getName() + "_" + oldProfile.getTag();
        this.configProfileMap.remove(key);
    }

    @Override
    public void modifyParmConfig(AParameterConfiguration config) {
        this.CURLOG.log(Level.WARNING, "file DAO: engineering mode not implemented");
    }

    @Override
    public Collection<AConfigProfile> getActiveProfilesForSubsystem(ASubsystemDescription description) {
        ArrayList<AConfigProfile> res = new ArrayList<AConfigProfile>();
        long requestedId = description.getId();
        for (String key : this.configProfileMap.keySet()) {
            ConfigProfile profile;
            if (key.startsWith("#") || (profile = this.configProfileMap.get(key)).getSubsystemDescription().getId() != requestedId) continue;
            res.add((AConfigProfile)profile);
        }
        return res;
    }

    @Override
    public Collection<PastConfigProfile> getProfilesForSubsystem(GhostSubsystemDescription description) {
        ArrayList<PastConfigProfile> res = new ArrayList<PastConfigProfile>();
        long requestedId = description.getId();
        for (String key : this.configProfileMap.keySet()) {
            ConfigProfile profile;
            if (!key.startsWith("#") || (profile = this.configProfileMap.get(key)).getSubsystemDescription().getId() != requestedId) continue;
            res.add((PastConfigProfile)profile);
        }
        return res;
    }

    @Override
    public void saveRun(RunHistory runHistory) {
        this.CURLOG.log(Level.WARNING, "file DAO: run history not implemented");
    }

    @Override
    public void savePreparedConfiguration(PreparedConfiguration preparedConfiguration) {
        this.CURLOG.log(Level.WARNING, "file DAO: prepared configuration not implemented");
    }

    @Override
    public PreparedConfiguration getPreparedConfiguration(String subsystemName, String configName, String tag) {
        this.CURLOG.log(Level.WARNING, "file DAO: prepared configuration not implemented");
        return null;
    }

    @Override
    public void saveMachineConfiguration(MachineConfiguration machineConfiguration) {
        this.CURLOG.log(Level.WARNING, "file DAO: machine configuration not implemented");
    }

    @Override
    public MachineConfiguration getMachineConfiguration(String macAddress) {
        this.CURLOG.log(Level.WARNING, "file DAO: machine configuration not implemented");
        return null;
    }

    @Override
    public List<?> simpleHQLRequest(String hqlString) {
        this.CURLOG.log(Level.WARNING, "file DAO: hql not implemented");
        return Collections.emptyList();
    }

    @Override
    public void close() {
    }
}

