package org.lsst.ccs.config;

import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Scanner;

/**
 * A set of static methods to be used on Configuration service client's side : they are hiding some implementation details to the "outside"
 * world.
 * To be used in conjunction with <TT>ConfigurationFacade</TT> (but
 * these codes may be called locally without referring to a server)
 * @author bamade
 */
// Date: 05/06/12

public class Factories {
    ////////// creation of "raw" subsystemDescriptions
    //TODO: normally the creation of all descriptions should be made from the text file
    // so no more public factories for these ?

    /**
     * Creates a new SubsystemDescription without any ParameterDescription creation. The object is not registered
     * in the database since it is to be populated by <TT>ParameterDescription</TT> objects.
     * <p/>
     * To populate the descriptions get the base descriptions from the Subsystemdescription by calling a version
     * of <TT>getBaseParameters</TT> or <TT>getParameterDescriptions</TT> and generate the descriptions from these bases.
     *
     * @param subsystemName
     * @param tag
     * @param user
     * @param version
     * @param configurationData
     * @param dataFlavour
     * @return
     */
    public static SubsystemDescription createRawSubsystemDescription(String subsystemName, String tag, String user, String version,
                                                              Serializable configurationData, DataFlavour dataFlavour) {
        return new ASubsystemDescription(subsystemName, tag, user, version, configurationData, dataFlavour);
    }

    /**
     * creates a "raw" subsystem description by reading a groovy text from file.
     * @param subsystemName
     * @param tag
     * @param user
     * @param version
     * @param inputStream
     * @param charSetName
     * @return
     */
    public static SubsystemDescription createRawSubsystemDescription(String subsystemName, String tag, String user, String version,
                                                                     InputStream inputStream, String charSetName) {

        // horrible hack: one liner for creating a String!
        String text = new Scanner(inputStream,charSetName).useDelimiter("\\A").next() ;
        return new ASubsystemDescription(subsystemName, tag, user, version,text, DataFlavour.TREE_FROM_SOURCE) ;
    }

    /**
     * creates a new SubsystemDescription populated with "empty" <TT>ParameterDescriptions</TT>.
     * The object is not in the database since the list of descriptions should be modified first.
     * <P>
     *     TODO: this method will be modified to populate with parameterDescriptions that are not necessarily empty.
     *
     * @param subsystemName
     * @param tag
     * @param user
     * @param version
     * @param configurationData
     * @param dataFlavour
     * @param filter
     * @return
     */
    public static SubsystemDescription createSubsystemDescription(String subsystemName, String tag, String user, String version,
                                                           Serializable configurationData, DataFlavour dataFlavour, ParameterFilter filter) {
        ASubsystemDescription res = new ASubsystemDescription(subsystemName, tag, user, version, configurationData, dataFlavour);
        /* WAS !!!! what a bug!!!!
        Collection<ParameteBase> bases = res.getBaseParameters(filter);
        for (ParameterBase base : bases) {
            AParameterDescription desc = new AParameterDescription(base, "", "", "", 10);
            res.addParameterDescriptions(desc);
        }
        */
        Collection<ParameterDescription> descriptions = res.getPossibleDescriptions(PackCst.DESIGNER_LEVEL, filter) ;
        for(ParameterDescription description : descriptions) {
            res.addParameterDescriptions(description);
        }
        return res;
    }


    /**
     * creates a new SubsystemDescription from another. The other one could be active of deprecated data:
     * this method is meant to create another subsystemdescription were only the ParameterDescription are to be changed.
     * not that the list of ParameterDescription may be populated (if the model have some) and then that this set
     * is to be modified (the resulting object is not yet persisted in the database).
     *
     * @param desc
     * @return
     */
    public static SubsystemDescription createSubsystemDescriptionCopy(SubsystemDescription desc) {
        return new ASubsystemDescription(desc);
    }


    /**
     * factory method to create a new ParameterDescription. To be used by tools such as GUI
     *
     * @param parameterBase
     * @param description
     * @param simpleName
     * @param constraints
     * @param level
     * @return
     */
    public static ParameterDescription createParameterDescription(ParameterBase parameterBase, String description, String simpleName, String constraints, int level) {
        return new AParameterDescription(parameterBase, description, simpleName, constraints, level);
    }

    /**
     * factory method to create a new ParameterDescription from another one.
     *
     * @param other
     * @return
     */
    public static ParameterDescription createParameterDescription(ParameterDescription other) {
        return new AParameterDescription(other);
    }

    /**
     * tries to copy <TT>ParameterDescription</TT> from a model to a new subsystem description.
     * each <TT>ParameterDescription</TT> is checked against the configData (if not compatible it is rejected
     * and a Listener is notified).
     * <p/>
     * NOT IMPLEMENTED YET
     * </P>
     *
     * @param newDescription   a subsystem description <B>without</B> any <TT>ParameterDescription</TT>
     * @param model
     * @param mismatchListener optional code that will be warned when inconsistencies occur
     */
    public static void tryCopyParameters(SubsystemDescription newDescription, SubsystemDescription model,
                                  DescriptionMismatchListener mismatchListener) {
        // generate a bogus ParameterBase list for newDescription
        // test if type is the same ?(default value may be changed)
        // new defaultValue tested against "constraints"
        // level set to old level
        System.err.println("Try copy Parameters not implemented yet");
    }


    ////////////// creation of "raw" configProfiles

    /**
     * Creates a new ConfigProfile that has no ParameterConfiguration (and so is not ready
     * to be persisted).
     *
     * @param subsystemDesc should  be read from the database
     * @param name
     * @param tag
     * @param userName
     * @param level
     * @return
     * @throws IllegalArgumentException if subsystemdescription not in database
     */
    public static ConfigProfile createRawConfigProfile(SubsystemDescription subsystemDesc, String name, String tag, String userName, int level) {
        if (!(subsystemDesc instanceof ASubsystemDescription)) {
            throw new IllegalArgumentException("deprecated Description");
        }
        return createRawConfigProfile((ASubsystemDescription) subsystemDesc, name, tag, userName, level);
    }

    static AConfigProfile createRawConfigProfile(ASubsystemDescription subsystemDesc, String name,  String userName, int level) {
        //TODO: check for preconditions
        return new AConfigProfile(subsystemDesc, name,  userName, level);
    }

    /// possible parameters is a method of A configProfile

    /**
     * Creates a new ConfigProfile with ParameterConfiguration where values
     * are just copied from the Description default value.
     *
     * @param subsystemDesc should be already in the database
     * @param name
     * @param tag
     * @param userName
     * @param level
     * @return
     * @throws IllegalArgumentException if subsystemdescription not in database
     */
    public static ConfigProfile createConfigProfile(SubsystemDescription subsystemDesc, String name, String tag, String userName, int level) {
        if (!(subsystemDesc instanceof ASubsystemDescription)) {
            throw new IllegalArgumentException("deprecated Description");
        }

        return createConfigProfile((ASubsystemDescription) subsystemDesc, name, tag, userName, level);
    }

    static AConfigProfile createConfigProfile(ASubsystemDescription subsystemDesc, String name, String tag, String userName, int level) {
        //TODO: check for preconditions
        AConfigProfile res = new AConfigProfile(subsystemDesc, name,  userName, level);
        /* WRONG ! DO NOT DO THAT!
        Set<AParameterDescription> descriptionSet = res.getPossibleParameters();
        for (AParameterDescription parmDesc : descriptionSet) {
            AParameterConfiguration conf = new AParameterConfiguration(parmDesc);
            res.addParameterConfigurations(conf);
        }
        */
        return res;
    }

    /**
     * to be used to create a copy of configuration with different name , tag, etc.
     * This is used mostly to go back and forth in Engineering mode: for instance start
     * an Engineering mode with modification of parameters "on the fly"
     * <p/>
     * when this is used to create an "engineering mode" profile it is mandatory that the profile
     * to be copied is an active one (not a deprecated one)
     *
     * @param toBeCopied    for the moment should be an "active" ConfigProfile (not a deprecated one)
     * @param newName
     * @param newUserName
     * @param newLevel
     * @param toEngineering
     * @return
     */
    public static ConfigProfile copyProfile(ConfigProfile toBeCopied, String newName,
                                     String newUserName, int newLevel, boolean toEngineering) {
        if (toBeCopied instanceof AConfigProfile) {
            return new AConfigProfile((AConfigProfile) toBeCopied, newName,
                    newUserName, newLevel, toEngineering);
        }
        if (toEngineering) {
            throw new IllegalArgumentException("cannot create an engineering profile from a deprecated one");
        }
        throw new UnsupportedOperationException("copy with deprecated profile not yet implemented");
    }

    /**
     * create a new Profile copying a profile created during an engineering session
     * @param toBeCopied
     * @param newName
     * @param userName
     * @param newLevel
     * @param getRidOfStaticParameters
     * @return
     */
    public static ConfigProfile copyProfileForRegistration(ConfigProfile toBeCopied, String newName, String userName, int newLevel, boolean getRidOfStaticParameters ) {
        ConfigProfile res = copyProfile(toBeCopied,newName,userName,newLevel, false) ;
        if(getRidOfStaticParameters) {
            for (ParameterConfiguration parmConf : res.getModifiedParameters()) {
                if (parmConf.changingStaticData) {
                    res.removeParameterConfigurations(parmConf);
                }
            }
            res.setChangingStaticData(false);
        }
        return res ;
    }

    /**
     * factory method to create a ParameterConfiguration object
     *
     * @param description
     * @param value
     * @return
     */
    public static ParameterConfiguration createParameterConfiguration(ParameterDescription description, String value) {
        if (!(description instanceof AParameterDescription)) {
            throw new IllegalArgumentException("deprecated description");
        }
        if(description.getId() == 0L) {
            throw new IllegalArgumentException("ParameterDescription not registered in base" + description) ;
        }
        return new AParameterConfiguration((AParameterDescription) description, value, true);
    }

    /**
     * factory method to create a ParameterConfiguration object
     *
     * @param description
     * @return
     */
    public static ParameterConfiguration createParameterConfiguration(ParameterDescription description) {
        if (!(description instanceof AParameterDescription)) {
            throw new IllegalArgumentException("deprecated description");
        }
        if(description.getId() == 0L) {
            throw new IllegalArgumentException("ParameterDescription not registered in base" + description) ;
        }
        return new AParameterConfiguration((AParameterDescription) description);
    }

    /**
     * tries to create a new ConfigProfile from an old one. The new one is matched to an active
     * subsystemDescription
     * <p/>
     * NOT IMPLEMENTED YET
     * </P>
     *
     * @param oldProfile
     * @param newDescription   an active subsystemDescription already registered in the databse
     * @param mismatchListener
     * @return
     */
    //TODO: implement that!
    public static ConfigProfile repair(ConfigProfile oldProfile, SubsystemDescription newDescription,
                                ConfigurationMismatchListener mismatchListener) {
        return null;
    }


}
