package org.lsst.ccs.config;

import org.hibernate.annotations.Immutable;

import javax.persistence.Entity;
import javax.persistence.Id;

/**
 * instances of this class can only be created by the Configuration facade.
 * They are "zombies" that represent an instance of Parameter descriptions that may be
 * "dead" or "alive". When a parameter description actually "dies" the end date in the
 * corresponding Subsystem Description Object is changed to a real date (not STILL_VALID).
 * These objects are in a separate table in the database their ID is exactly the same as the one
 * in the living object.
 * @author bamade
 */
// Date: 10/04/12

    @Entity
    @Immutable // change that if EndDate is inserted (changed when object is deprecated)
    //@Table(name="ParmDescriptionHistory")
class GhostParameterDescription extends ParameterDescription {
    private static final long serialVersionUID = -9140905063378188378L;
    @Id
    private long id ; // not generated

    ///////////////////// CONSTRUCTORS


    GhostParameterDescription() {
    }

    protected GhostParameterDescription(AParameterDescription other) {
        super(other);
        //post verification
        if (0L == this.getId()) {
            throw new IllegalArgumentException(
                    "Ghost can be created only from a registered Parameter Description (with generated id)") ;
        }
    }

    ///////////////////////////// ACCESSORS/MUTATORS
    @Override
    public long getId() {
        return id;
    }
    @Override
    protected void setId(long id) {
        this.id = id ;
    }
}
