/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.Serializable;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Lob;
import org.lsst.ccs.config.ConfigProfile;
import org.lsst.ccs.config.NamesAndTag;
import org.lsst.gruth.jutils.ComponentNode;

@Entity
public class PreparedConfiguration
implements Serializable {
    private static final long serialVersionUID = -6386284584439938312L;
    @EmbeddedId
    private NamesAndTag nameAndTag = new NamesAndTag();
    private boolean fromProfile;
    private String user;
    @Lob
    private ComponentNode configuredData;

    PreparedConfiguration() {
    }

    public PreparedConfiguration(String namedReference, String tag, String subsystemName, String user, boolean fromProfile, ComponentNode configuredData) {
        this.nameAndTag.setConfigName(namedReference);
        this.nameAndTag.setTag(tag);
        this.nameAndTag.setSubsystemName(subsystemName);
        this.user = user;
        this.fromProfile = fromProfile;
        this.configuredData = configuredData;
    }

    public PreparedConfiguration(ConfigProfile profile) {
        ComponentNode configuredData;
        this.nameAndTag.setConfigName(profile.getName());
        this.nameAndTag.setTag(profile.getTag());
        this.nameAndTag.setSubsystemName(profile.getSubsystemDescription().getSubsystemName());
        this.user = profile.getUserName();
        this.fromProfile = true;
        this.configuredData = configuredData = profile.getModifiedConfigurationData();
    }

    public boolean isFromProfile() {
        return this.fromProfile;
    }

    void setFromProfile(boolean fromProfile) {
        this.fromProfile = fromProfile;
    }

    public ComponentNode getConfiguredData() {
        return this.configuredData;
    }

    void setConfiguredData(ComponentNode configuredData) {
        this.configuredData = configuredData;
    }

    public String getSubsystemName() {
        return this.nameAndTag.getSubsystemName();
    }

    public NamesAndTag getNameAndTag() {
        return this.nameAndTag;
    }

    void setNameAndTag(NamesAndTag nameAndTag) {
        this.nameAndTag = nameAndTag;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getConfigName() {
        return this.nameAndTag.getConfigName();
    }

    public String getTag() {
        return this.nameAndTag.getTag();
    }
}

