package org.lsst.ccs.config;

import org.lsst.gruth.jutils.ComponentNode;

import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Lob;
import java.io.Serializable;

/**
 * objects of this class represent a complete set of data with modified configuration parameters that can be used to start
 * a subsystem.
 */
@Entity
public class PreparedConfiguration implements Serializable {
    private static final long serialVersionUID = -6386284584439938312L;
    @EmbeddedId
    private NamesAndTag nameAndTag = new NamesAndTag() ;
    private boolean fromProfile ;
    private String user ;
    @Lob // tinyLOb!
    private ComponentNode configuredData ;

    //TODO: add deployment descriptors
    /////////////////////////////////// CONSTRUCTORS

    PreparedConfiguration() {
    }

    public PreparedConfiguration(String namedReference, String tag, String subsystemName, String user, boolean fromProfile,
                                 ComponentNode configuredData) {
        this.nameAndTag.setConfigName(namedReference);
        this.nameAndTag.setTag(tag);
        this.nameAndTag.setSubsystemName(subsystemName);
        this.user = user ;
        this.fromProfile = fromProfile;
        this.configuredData = configuredData;
    }

    public PreparedConfiguration(ConfigProfile profile) {
        this.nameAndTag.setConfigName(profile.getName());
        this.nameAndTag.setTag(profile.getTag());
        this.nameAndTag.setSubsystemName(profile.getSubsystemDescription().getSubsystemName());
        this.user = profile.getUserName() ;
        this.fromProfile = true;
        ComponentNode configuredData = profile.getModifiedConfigurationData();
        this.configuredData = configuredData;

    }

    //////////////////////////////// ACCESSORS/MUTATORS

    public boolean isFromProfile() {
        return fromProfile;
    }

     void setFromProfile(boolean fromProfile) {
        this.fromProfile = fromProfile;
    }


    public ComponentNode getConfiguredData() {
        return configuredData;
    }

     void setConfiguredData(ComponentNode configuredData) {
        this.configuredData = configuredData;
    }

    public String getSubsystemName() {
        return nameAndTag.getSubsystemName();
    }


    public NamesAndTag getNameAndTag() {
        return nameAndTag;
    }

    void setNameAndTag(NamesAndTag nameAndTag) {
        this.nameAndTag = nameAndTag;
    }

    public String getUser() {
        return user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getConfigName() {
        return nameAndTag.getConfigName() ;
    }

    public String getTag() {
        return nameAndTag.getTag() ;
    }
}
