package org.lsst.ccs.config;

import javax.persistence.*;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * A parameter configuration in history.
 * Those can be resuscitated using the <TT>repair</TT> methods of
 * <TT>ConfigFacade</TT>
 * @author bamade
 */
// Date: 11/04/12

    @Entity
//@Table(name="ParmConfigurationHistory")
class PastParameterConfiguration extends ParameterConfiguration{
    @Id
    private long id ; // not generated
    //TODO: EAGER not obvious
    @ManyToOne //(fetch=FetchType.EAGER)
    private /*@NotNull*/ GhostParameterDescription parameterDescription ;

    @OneToMany (cascade = CascadeType.PERSIST, fetch=FetchType.EAGER)
    private List<PastValueEvent> valueEvents ;

    //////////////////////////// CONSTRUCTOR


    PastParameterConfiguration() {
    }

    /**
     * creates historic data from a Parameter configuration and the "ghost" corresponding to its description.
     * @param ghostDescription
     * @param oldConfig
     * @throws IllegalArgumentException if ghost and description do not match!
     */
    PastParameterConfiguration(GhostParameterDescription ghostDescription,AParameterConfiguration oldConfig) {
        super(oldConfig.getValue());
        if(oldConfig.getId() == 0L) {
            throw new IllegalArgumentException("trying to create historical data with a non-registered object") ;
        }
        if(ghostDescription.getId() != oldConfig.getDescription().getId()) {
            throw new IllegalArgumentException("description and its ghost with different ids") ;
        }
        this.id = oldConfig.getId() ;
        this.parameterDescription = ghostDescription;
        List<AValueEvent> listEvents = oldConfig.valueEvents ;
        if(listEvents != null) {
            int size = listEvents.size() ;
            ArrayList<PastValueEvent> newList = new ArrayList<PastValueEvent>(size) ;
            for(AValueEvent oldEvent : listEvents) {
                newList.add(new PastValueEvent(oldEvent)) ;
            }
            setValueEvents(newList);
        }

    }

    //////////////////////////// ACCESSORS/MUTATORS
    @Override
    public long getId() {
        return id;
    }

    @Override
    protected void setId(long id) {
        this.id = id ;
    }

    @Override
    public ParameterDescription getDescription() {
        return parameterDescription;
    }

    @Override
    public List<? extends ValueEvent> getValueEvents() {
        return valueEvents;
    }

    void setValueEvents(List<PastValueEvent> valueEventList) {
        if(valueEventList != null) {
            this.valueEvents = Collections.unmodifiableList(valueEventList) ;
        }
    }

    /*
    @Override
    public void addValueEvent(ValueEvent event) {
        throw new ImmutableStateException("no modification of deprecated data") ;
    } */

    GhostParameterDescription getParameterDescription() {
        return parameterDescription;
    }

     void setParameterDescription(GhostParameterDescription parameterDescription) {
        this.parameterDescription = parameterDescription;
    }
}
