package org.lsst.ccs.config;

import java.util.Collection;
import java.util.List;

/**
 * abstract class used to help build DAO that uses HQL but are in a different package
 * @author bamade
 */
// Date: 12/03/13

public abstract class HqlDAO  implements DBInterface{
    /**
     * delegate to Hibernate Query type
     */
    //todo : enrich if necessary
    public interface AbstractQuery {
        List list() ;
    }

    /**
     * delegate to Hibernate Session type
     */
    //todo enrich if necessary
    public interface AbstractSession {
        AbstractQuery createQuery(String queryString) ;
        void saveOrUpdate(Object arg) ;
        void save(Object arg) ;
        void delete(Object arg) ;
        void flush() ;
    }

    protected AbstractSession session ;
    protected boolean exceptionFired ;

    public AbstractSession getSession() {
        return session;
    }

    public void setSession(AbstractSession session) {
        this.session = session;
    }

    /////////////////////// DB Interface contract

    @Override
    public void saveSubsystemDescription(ASubsystemDescription newDescription) {
        newDescription.setStartTimestamp(System.currentTimeMillis());
        // paremeter description comments my be modified
        session.saveOrUpdate(newDescription); ;
    }

    @Override
    public void saveGhostDescriptions(GhostSubsystemDescription ghosts) {
        session.save(ghosts) ;
    }

    @Override
    public ASubsystemDescription getActiveSubsystemDescription(String name, String tag) {
        String request = "from ASubsystemDescription where subsystemName = '"+name+"' and tag = '"+tag +"'" ;
        AbstractQuery query = session.createQuery(request) ;
        List listRes = query.list();
        if(listRes.size() == 1) {
            return (ASubsystemDescription)listRes.get(0) ;
        }
        return null ;
    }

    @Override
    public ASubsystemDescription getActiveSubsystemDescription(long id) {
        String request = "from ASubsystemDescription where id = " +id  ;
        AbstractQuery query = session.createQuery(request) ;
        List listRes = query.list();
        if(listRes.size() == 1) {
            return (ASubsystemDescription)listRes.get(0) ;
        }
        return null ;
    }

    @Override
    public GhostSubsystemDescription getGhostDescription(long id) {
        String request = "from GhostSubsystemDescription where id = '"+id+"'" ;
        AbstractQuery query = session.createQuery(request) ;
        List listRes = query.list();
        if(listRes.size() == 1) {
            return (GhostSubsystemDescription)listRes.get(0) ;
        }
        return null ;
    }

    @Override
    public void deleteActiveSubsystemDescription(ASubsystemDescription oldDescription) {
        session.delete(oldDescription);
        // flush ?
        session.flush() ;
    }

    @Override
    public void saveConfigProfile(AConfigProfile newProfile) {
        newProfile.setStartTimestamp(System.currentTimeMillis());
        //TODO: what of referenced subsystem? dave? different cascade ?
        // remarks can be modified
        session.saveOrUpdate(newProfile);
    }

    @Override
    public void savePastProfile(PastConfigProfile deprecatedProfile) {
        session.save(deprecatedProfile) ;
    }

    @Override
    public AConfigProfile getActiveConfigProfile(String name, String tag) {
        String request = "from AConfigProfile where name = '"+name+"' and tag = '"+tag +"'" ;
        AbstractQuery query = session.createQuery(request) ;
        List listRes = query.list();
        if(listRes.size() == 1) {
            return (AConfigProfile) listRes.get(0) ;
        }
        return null ;
    }

    @Override
    public void deleteActiveConfigProfile(AConfigProfile oldProfile) {
        session.delete(oldProfile);
        //flush ? YES otherwise does not work!
        session.flush() ;
    }

    @Override
    public void modifyParmConfig(AParameterConfiguration config) {
        session.saveOrUpdate(config);
    }

    @Override
    public Collection<AConfigProfile> getActiveProfilesForSubsystem(ASubsystemDescription description) {
        //TODO: check if simpler join is not more coherent
        String request = "from AConfigProfile where subsystemId = '"+description.getId()+"'" ;
        AbstractQuery query = session.createQuery(request) ;
        List listRes = query.list();
        return (Collection<AConfigProfile>)listRes ;
    }

    @Override
    public Collection<PastConfigProfile> getProfilesForSubsystem(GhostSubsystemDescription description) {
        //TODO: check if simpler  using id
        //TODO: RECHECK THIS! LOOKS FAULTY
        //String request = "from PastConfigProfile where subsystemDesc = "+description+"" ;
        String request = "from PastConfigProfile where subsystemDesc.id = "+description.getId()+"" ;
        AbstractQuery query = session.createQuery(request) ;
        List listRes = query.list();
        return (Collection<PastConfigProfile>)listRes ;
    }

    @Override
    public void saveRun(RunHistory runHistory) {
        session.save(runHistory) ;
    }

    @Override
    public void savePreparedConfiguration(PreparedConfiguration preparedConfiguration) {
        session.save(preparedConfiguration);
    }

    @Override
    public PreparedConfiguration getPreparedConfiguration(String subsystemName, String configName, String tag) {
        String request = "from PreparedConfiguration where subsystemName = '" +subsystemName +"'" ;
        if(configName != null && !"".equals(configName)) {
            request += " and configName = '" + configName +"'" ;
        }
        if(tag != null && !"".equals(tag)) {
            request += " and tag = '" + tag +"'" ;
        }
        AbstractQuery query = session.createQuery(request) ;
        List listRes = query.list();
        if(listRes.size() == 1) {
            return (PreparedConfiguration)listRes.get(0) ;
        }
        return null;
    }

    @Override
    public void saveMachineConfiguration(MachineConfiguration machineConfiguration) {
        session.save(machineConfiguration) ;
    }

    @Override
    public MachineConfiguration getMachineConfiguration(String macAddress) {
        String request = "from MachineConfiguration where macAddress = '" + macAddress + "'" ;
        AbstractQuery query = session.createQuery(request) ;
        List listRes = query.list();
        if(listRes.size() == 1) {
            return (MachineConfiguration)listRes.get(0) ;
        }
        return null;  //To change body of implemented methods use File | Settings | File Templates.
    }

    @Override
    public List<?> simpleHQLRequest(String hqlString) {
        AbstractQuery query = session.createQuery(hqlString) ;
        return query.list() ;
    }

}
