/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Set;
import org.lsst.ccs.config.FileWriterProvider;
import org.lsst.ccs.config.InMemoryWriterProvider;
import org.lsst.ccs.config.WriterProvider;

class InMemoryFileWriterProvider
extends WriterProvider {
    private final WriterProvider inMemoryWriterProvider;
    private final WriterProvider fileWriterProvider;
    public static boolean ALWAYS_FIND_FILENAME = true;
    public static boolean FAIL_ONCE_TO_GET_WRITER = false;

    InMemoryFileWriterProvider() {
        this(new InMemoryWriterProvider(), new FileWriterProvider());
    }

    InMemoryFileWriterProvider(InMemoryWriterProvider inMemoryWriterProvider, FileWriterProvider fileWriterProvider) {
        this.inMemoryWriterProvider = inMemoryWriterProvider;
        this.fileWriterProvider = fileWriterProvider;
    }

    public PrintWriter getPrintWriter(String fileName) throws IOException {
        if (FAIL_ONCE_TO_GET_WRITER) {
            FAIL_ONCE_TO_GET_WRITER = false;
            throw new IOException("Could not open file " + fileName);
        }
        return this.inMemoryWriterProvider.getPrintWriter(fileName);
    }

    public InputStream getInputStream(String fileName) throws IOException {
        InputStream is1 = this.inMemoryWriterProvider.getInputStream(fileName);
        if (is1 == null) {
            InputStream is2 = this.fileWriterProvider.getInputStream(fileName);
            if (is2 == null) {
                if (ALWAYS_FIND_FILENAME) {
                    return new ByteArrayInputStream(new byte[0]);
                }
                return null;
            }
            PrintWriter printW = this.getPrintWriter(fileName);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.fileWriterProvider.getInputStream(fileName)));){
                while (reader.ready()) {
                    String line = reader.readLine();
                    printW.write(line + "\n");
                    printW.flush();
                }
                printW.close();
            }
            is1 = is2;
        }
        return is1;
    }

    Set<String> findMatchingPropertiesFiles(String pattern) {
        Set foundFiles = this.fileWriterProvider.findMatchingPropertiesFiles(pattern);
        Set foundInMemory = this.inMemoryWriterProvider.findMatchingPropertiesFiles(pattern);
        foundFiles.addAll(foundInMemory);
        return foundFiles;
    }

    String locateFile(String fileName) {
        return this.inMemoryWriterProvider.locateFile(fileName);
    }
}

