package org.lsst.ccs.commons.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Fields annotated by this annotation have their value persisted in a local
 * file.
 * <p>
 * At startup, when {@code Agent.start()} is called, the file is read and
 * persisted values are applied to the corresponding field.
 * <p>
 * To trigger the local persistence of annotated fields, invoke
 * {@link org.lsst.ccs.framework.Subsystem#persistNow}
 * <p>
 * Supported annotated field types are the same as the ones supported by the
 * configuration service since serialization/deserialization relies on
 * {@link org.lsst.ccs.utilities.conv.TypeUtils#stringify} and
 * {@link org.lsst.ccs.utilities.conv.InputConversionEngine#convertArgToType}.
 *
 * @author LSST CCS Team
 */
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface Persist {
    
}
