package org.lsst.ccs.drivers.commons;

public interface MonochromatorDriver {

    /**
     * Open the communication port - meaning of parameter is OS and
     * driver-dependent
     * 
     * For serial on Unix can be /dev/ttyXXX
     * 
     * @param portName
     */
    public abstract void open(String portName) throws DriverException;

    /**
     * set wavelength in nanometers
     */
    public abstract void setWave(double param) throws DriverException;

    /**
     * get current wavelength in nanometers
     */
    public abstract double getWave() throws DriverException;

    /**
     * Advance by a number of steps
     * 
     * @param steps
     *            positive or negative offset, in steps
     */
    public abstract void advanceSteps(int steps) throws DriverException;

    /**
     * get absolute position in steps
     * 
     */
    public abstract int getStep() throws DriverException;

}
