package org.lsst.ccs.commons.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Fields of a class annotated with this annotation will be tracked down by the
 * configuration service.
 * @author The lSST CCS Team
 */
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface ConfigurationParameter {
    
    /**
     * A description for this parameter.
     * @return 
     */
    String description() default ""; 
    
    /**
     * The units for this parameter.
     * @return 
     */
    String units() default ""; 

    /**
     * The name under which this parameter is known to the configuration service.
     * If "" or not set, the name of the field itself is picked up.
     */
    String name() default ""; // if "" then null is assumed
    
    /**
     * The category this parameters belongs to.
     */
    String category() default "";
    
    /**
     * A range constraint associated to this parameter.
     * @return a String representation of the range.
     */
    String range() default "";
    
    /**
     * Specifies if this parameter can be changed at initialization phase only.
     * It is false by default.
     * @return true if this parameter can be changed at initialization phase 
     * only, false otherwise.
     */
    boolean isFinal() default false;
    
    /**
     * Specifies if this configuration parameter is to be treated as read-only.
     * The configuration service will not try to set it, but it will monitor
     * its value and publish it along when ConfigurationInfo data is published.
     * 
     * 
     */
    boolean isReadOnly() default false;
    
}
