package org.lsst.ccs.commons.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Fields annotated by this annotation have their value persisted in a local
 * file. At startup, when {@code Agent.start()} is called, the file is read and
 * persisted values are applied to the corresponding field. At shutdown, the
 * file is written after all client overridable methods are called, with the
 * current values of the persist fields. Supported types are the same as the
 * ones supported by the configuration service since
 * serialization/deserialization relies on
 * T{@code org.lsst.ccs.utilities.conv.TypeUtils#stringify} and
 * {@code org.lsst.ccs.utilities.conv.InputConversionEngine#convertArgToType}.
 *
 * @author LSST CCS Team
 */
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface Persist {
    
}
