package org.lsst.ccs.drivers.commons;

public interface PowerSupplyDriver {

   /**
    ***************************************************************************
    **
    **  Opens a connection to the power supply.
    **
    **  Arguments are device dependent.
    **
    **  @param  connType  The connection type: e.g. network, serial, FTDI
    **
    **  @param  ident     The device identifier: e.g. node name, USB s/n
    **
    **  @param  param     The device parameter: e.g. port number, baud rate
    **
    **  @throws  DriverException
    **
    ***************************************************************************
    */
    public void open(int connType, String ident, int param)
        throws DriverException;


   /**
    ***************************************************************************
    **
    **  Closes the connection.
    **
    **  @throws  DriverException
    **
    ***************************************************************************
    */
    public void close() throws DriverException;


   /**
    ***************************************************************************
    **
    **  Turns output on or off for a channel.
    **
    **  @param  on    Turn on if true, off if false
    **
    **  @param  chan  The channel number
    **
    **  @throws  DriverException
    **
    ***************************************************************************
    */
    public void setOutput(boolean on, int chan) throws DriverException;


   /**
    ***************************************************************************
    **
    **  Gets the output state of a channel.
    **
    **  @param  chan  The channel number
    **
    **  @return  The output state
    **
    **  @throws  DriverException
    **
    ***************************************************************************
    */
    public boolean getOutput(int chan) throws DriverException;


   /**
    ***************************************************************************
    **
    **  Sets the power-on delay for a channel.
    **
    **  @param  time  The delay (sec)
    **
    **  @param  chan  The channel number
    **
    **  @throws  DriverException
    **
    ***************************************************************************
    */
    public void setOnDelay(double time, int chan) throws DriverException;


   /**
    ***************************************************************************
    **
    **  Sets the power-off delay for a channel.
    **
    **  @param  time  The delay (sec)
    **
    **  @param  chan  The channel number
    **
    **  @throws  DriverException
    **
    ***************************************************************************
    */
    public void setOffDelay(double time, int chan) throws DriverException;


   /**
    ***************************************************************************
    **
    **  Sets the voltage for a channel.
    **
    **  @param  value  The value to set
    **
    **  @param  chan   The channel number
    **
    **  @throws  DriverException
    **
    ***************************************************************************
    */
    public void setVoltage(double value, int chan) throws DriverException;


   /**
    ***************************************************************************
    **
    **  Gets the set voltage for a channel.
    **
    **  @param  chan   The channel number
    **
    **  @return  The voltage
    **
    **  @throws  DriverException
    **
    ***************************************************************************
    */
    public double getVoltage(int chan) throws DriverException;


   /**
    ***************************************************************************
    **
    **  Reads the voltage for a channel.
    **
    **  @param  chan  The channel number
    **
    **  @return  The voltage
    **
    **  @throws  DriverException
    **
    ***************************************************************************
    */
    public double readVoltage(int chan) throws DriverException;


   /**
    ***************************************************************************
    **
    **  Sets the current for a channel.
    **
    **  @param  value  The value to set
    **
    **  @param  chan   The channel number
    **
    **  @throws  DriverException
    **
    ***************************************************************************
    */
    public void setCurrent(double value, int chan) throws DriverException;


   /**
    ***************************************************************************
    **
    **  Gets the set current for a channel.
    **
    **  @param  chan   The channel number
    **
    **  @return  The current
    **
    **  @throws  DriverException
    **
    ***************************************************************************
    */
    public double getCurrent(int chan) throws DriverException;


   /**
    ***************************************************************************
    **
    **  Reads the current for a channel.
    **
    **  @param  chan  The channel number
    **
    **  @return  The current
    **
    **  @throws  DriverException
    **
    ***************************************************************************
    */
    public double readCurrent(int chan) throws DriverException;

}
