package org.lsst.ccs.commons.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 *
 * @author The lSST CCS Team
 */
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface ConfigurableParameter {
    
    String description() default ""; 
    
    /**
     * The name under which this parameter is known to the configuration service.
     * If "" or not set, the name of the field itself is picked up.
     */
    String name() default ""; // if "" then null is assumed
    
    /**
     * A simpler name for this parameter.
     */
    String simpleName() default "";
    
    /**
     * A constraint as a String.
     */
    String constraints() default "";
    
    int level() default 0;
    
    /**
     * True if the parameter cannot be changed at runtime
     */
    boolean isStatic() default false;
    
    /**
     * The category this parameters belongs to.
     */
    String category() default "";
    
    /**
     * The default value assigned to this parameter at construction
     */
    String defaultValue();
}
