package org.lsst.ccs.commons.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Marks a mutator ("setter") as being part of possible configuration change.
 * Such a method is invoked through the change command, and followed by a change
 * notification to the configuration service.
 * 
 * @author The LSST CCS team
 */
@Documented
@Target(ElementType.METHOD)
@Retention( RetentionPolicy.RUNTIME)
public @interface ParameterChanger {
    // TODO : Interfaces cannot be extended, the annotation elements have to be redefined.
    /**
     * A short explanation on what the configuration command does.
     * @return
     */
    String doc()  default "";

    String propertyName() default "";
}
