package org.lsst.ccs.common.devices.power.distribution;

import org.lsst.ccs.commons.annotations.ConfigurationParameter;

/**
 * A PDU outlet.
 * 
 * @author LSST CCS Team
 */
public class PduOutlet {

    @ConfigurationParameter(isFinal = true)
    private String name;
    
    @ConfigurationParameter(isFinal = true)
    private int index;
    
    public PduOutlet(String str) {   
        str = str.trim();
        int i = str.indexOf(":");
        if ( i < 0 ) {
            throw new IllegalArgumentException("Cannot build PduOutlet from string "+str);
        }
        name = str.substring(0,i);
        index = Integer.valueOf(str.substring(i+1,str.length()));
    }

    public PduOutlet(String name, int index) {
        this(name+":"+index);        
    }
    
    @Override
    public String toString() {
        return name+":"+index;
    }

    public String getName() {
        return name;
    }

    public int getIndex() {
        return index;
    }

    
    
}


