/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.shell;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ListIterator;
import jline.console.ConsoleReader;
import jline.console.history.History;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.CommandSetBuilder;
import org.lsst.ccs.command.CompositeCommandSet;
import org.lsst.ccs.shell.JLineShell;

public class CommandHistoryTest {
    @Test
    public void testHistory() throws IOException {
        CommandSetBuilder builder = new CommandSetBuilder();
        CompositeCommandSet compositeSet = new CompositeCommandSet();
        int nCommands = 500;
        String lsCmd = "ls\n";
        String historyCmd = "history\n";
        ArrayList<ByteArrayInputStream> streams = new ArrayList<ByteArrayInputStream>();
        for (int i = 0; i < nCommands; ++i) {
            streams.add(new ByteArrayInputStream(lsCmd.getBytes()));
            streams.add(new ByteArrayInputStream(historyCmd.getBytes()));
        }
        String cmdFromHistory = "!567\n";
        streams.add(new ByteArrayInputStream(cmdFromHistory.getBytes()));
        SequenceInputStream all = new SequenceInputStream(Collections.enumeration(streams));
        ConsoleReader reader = new ConsoleReader((InputStream)all, new OutputStream(){

            @Override
            public void write(int b) throws IOException {
            }
        });
        JLineShell shell = new JLineShell((CommandSet)compositeSet);
        for (int i = 0; i < 2 * nCommands; ++i) {
            String string = reader.readLine();
        }
        String cmd = reader.readLine();
        History history = reader.getHistory();
        Assert.assertEquals((long)500L, (long)history.size());
        Assert.assertEquals((long)1001L, (long)history.index());
        ListIterator entries = history.entries();
        String lastCommand = "";
        while (entries.hasNext()) {
            History.Entry e = (History.Entry)entries.next();
            lastCommand = e.value().toString();
        }
        Assert.assertEquals((Object)"ls", (Object)lastCommand);
    }
}

