package org.lsst.ccs.command;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

/**
 * A Class containing the set of user specified options.
 * 
 * An instance of this class is passed during method invocation of a command
 * that supports options.
 * 
 */
public class Options implements Serializable {

    private final Set<String> options = new HashSet<>();
    private static final long serialVersionUID = 345738952754085472L;


    public Options withOption(String opt) {
        options.add(opt);
        return this;
    }
    
    public boolean hasOption(String option) {
        return options.contains(option);
    }

    @Override
    public String toString() {
        return "Options{" + "options=" + options + '}';
    }
       
    public boolean hasOptions() {
        return !options.isEmpty();
    }
    
    public Set<String> getOptions() {
        return new LinkedHashSet<>(options);
    }
    
}
