/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import junit.framework.TestCase;
import org.lsst.ccs.command.BasicCommand;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.CommandSetBuilder;
import org.lsst.ccs.command.CompositeCommandSet;
import org.lsst.ccs.command.RoutingCommandSet;
import org.lsst.ccs.command.TokenizedCommand;
import org.lsst.ccs.command.demo.DemoCommands;
import org.lsst.ccs.command.demo.ExtendedDemoCommands;

public class CommandSetConcurrencyTest
extends TestCase {
    private CommandSet commandSet;
    private CommandSet extendedCommandSet;
    private CompositeCommandSet ccs = new CompositeCommandSet();

    protected void setUp() throws Exception {
        CommandSetBuilder builder = new CommandSetBuilder();
        this.commandSet = builder.buildCommandSet((Object)new DemoCommands());
        this.extendedCommandSet = builder.buildCommandSet((Object)new ExtendedDemoCommands());
        this.ccs.add(this.commandSet);
    }

    public void testInvokeCommand() throws Exception {
        ExecutorService s = Executors.newFixedThreadPool(2);
        Future<?> f = s.submit(() -> this.addDictionaries());
        Future<?> f1 = s.submit(() -> this.invokeAdd());
        f.get();
        f1.get();
    }

    private void invokeAdd() {
        try {
            for (int i = 0; i < 10000; ++i) {
                TokenizedCommand tc = new TokenizedCommand("add 5 6");
                Object result = this.ccs.invoke((BasicCommand)tc);
                CommandSetConcurrencyTest.assertEquals((Object)11.0, (Object)result);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void addDictionaries() {
        try {
            for (int i = 0; i < 1000; ++i) {
                RoutingCommandSet crcs = new RoutingCommandSet("r" + i, this.extendedCommandSet);
                this.ccs.add((CommandSet)crcs);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

