/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Iterator;
import java.util.zip.CRC32;
import java.util.zip.GZIPInputStream;
import junit.framework.TestCase;
import org.junit.Assert;
import org.lsst.ccs.command.CommandDictionaryBuilder;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.CommandSetBuilder;
import org.lsst.ccs.command.CompositeCommandSet;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.DictionaryUtils;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.command.demo.CommandsWithDefaultArguments;
import org.lsst.ccs.command.demo.DemoCommands;
import org.lsst.ccs.command.demo.ExceptionCommands;

public class DictionaryChecksumTest
extends TestCase {
    public void testChecksum() {
        CommandDictionaryBuilder builder1 = new CommandDictionaryBuilder(DemoCommands.class);
        Dictionary dict1 = builder1.getCommandDictionary();
        CommandDictionaryBuilder builder2 = new CommandDictionaryBuilder(DemoCommands.class);
        Dictionary dict2 = builder2.getCommandDictionary();
        Assert.assertEquals((long)this.evaluateChecksum(dict1), (long)this.evaluateChecksum(dict2));
        byte[] dictSer1 = this.serialize(dict1);
        byte[] dictSer2 = this.serialize(dict2);
        Assert.assertEquals((long)this.evaluateChecksum(dictSer1), (long)this.evaluateChecksum(dictSer2));
        Dictionary finalDict1 = (Dictionary)this.deserialize(dictSer1);
        Dictionary finalDict2 = (Dictionary)this.deserialize(dictSer2);
        Assert.assertEquals((long)this.evaluateChecksum(finalDict1), (long)this.evaluateChecksum(finalDict2));
        Iterator iter1 = dict1.iterator();
        Iterator iter2 = dict2.iterator();
        Iterator final_iter1 = finalDict1.iterator();
        Iterator final_iter2 = finalDict2.iterator();
        for (int i = 0; i < finalDict1.size(); ++i) {
            DictionaryCommand cmd1 = (DictionaryCommand)iter1.next();
            DictionaryCommand cmd2 = (DictionaryCommand)iter2.next();
            Assert.assertEquals((long)this.evaluateChecksum(cmd1), (long)this.evaluateChecksum(cmd2));
            DictionaryCommand finalCmd1 = (DictionaryCommand)final_iter1.next();
            DictionaryCommand finalCmd2 = (DictionaryCommand)final_iter2.next();
            Assert.assertEquals((long)this.evaluateChecksum(finalCmd1), (long)this.evaluateChecksum(finalCmd2));
            Assert.assertTrue((boolean)DictionaryUtils.areDictionaryCommandsEqual((DictionaryCommand)cmd1, (DictionaryCommand)finalCmd2));
            Assert.assertTrue((boolean)DictionaryUtils.areDictionaryCommandsEqual((DictionaryCommand)finalCmd1, (DictionaryCommand)cmd2));
        }
        Assert.assertEquals((long)dict1.size(), (long)finalDict1.size());
        Assert.assertEquals((long)dict2.size(), (long)finalDict2.size());
        Assert.assertEquals((long)dict1.size(), (long)finalDict2.size());
        Assert.assertTrue((boolean)DictionaryUtils.areDictionariesEqual((Dictionary)dict1, (Dictionary)finalDict1));
        Assert.assertTrue((boolean)DictionaryUtils.areDictionariesEqual((Dictionary)dict1, (Dictionary)finalDict2));
        Assert.assertTrue((boolean)DictionaryUtils.areDictionariesEqual((Dictionary)dict2, (Dictionary)finalDict2));
    }

    public void testChecksumFromObjects() {
        CommandsWithDefaultArguments obj1 = new CommandsWithDefaultArguments();
        CommandsWithDefaultArguments obj2 = new CommandsWithDefaultArguments();
        CommandSetBuilder cmdBuilder = new CommandSetBuilder();
        CommandSet cmdSet1 = cmdBuilder.buildCommandSet((Object)obj1);
        CommandSet cmdSet2 = cmdBuilder.buildCommandSet((Object)obj2);
        Dictionary dict1 = cmdSet1.getCommandDictionary();
        dict1.setLevelForTypes(0, new Command.CommandType[]{Command.CommandType.QUERY});
        dict1.setLevelForTypes(3, new Command.CommandType[]{Command.CommandType.CONFIGURATION});
        dict1.setLevelForTypes(2, new Command.CommandType[]{Command.CommandType.ACTION});
        Dictionary dict2 = cmdSet2.getCommandDictionary();
        dict2.setLevelForTypes(0, new Command.CommandType[]{Command.CommandType.QUERY});
        dict2.setLevelForTypes(3, new Command.CommandType[]{Command.CommandType.CONFIGURATION});
        dict2.setLevelForTypes(2, new Command.CommandType[]{Command.CommandType.ACTION});
        Assert.assertEquals((long)this.evaluateChecksum(dict1), (long)this.evaluateChecksum(dict2));
        byte[] dictSer1 = this.serialize(dict1);
        byte[] dictSer2 = this.serialize(dict2);
        Assert.assertEquals((long)this.evaluateChecksum(dictSer1), (long)this.evaluateChecksum(dictSer2));
        Dictionary finalDict1 = (Dictionary)this.deserialize(dictSer1);
        Dictionary finalDict2 = (Dictionary)this.deserialize(dictSer2);
        Assert.assertEquals((long)this.evaluateChecksum(finalDict1), (long)this.evaluateChecksum(finalDict2));
        Assert.assertTrue((boolean)DictionaryUtils.areDictionariesEqual((Dictionary)dict1, (Dictionary)finalDict1));
    }

    public void testChecksumFromCompositeCommandSet() {
        CommandsWithDefaultArguments obj11 = new CommandsWithDefaultArguments();
        ExceptionCommands obj12 = new ExceptionCommands();
        CommandsWithDefaultArguments obj21 = new CommandsWithDefaultArguments();
        ExceptionCommands obj22 = new ExceptionCommands();
        CommandSetBuilder cmdBuilder = new CommandSetBuilder();
        CommandSet cmdSet11 = cmdBuilder.buildCommandSet((Object)obj11);
        CommandSet cmdSet12 = cmdBuilder.buildCommandSet((Object)obj12);
        CommandSet cmdSet21 = cmdBuilder.buildCommandSet((Object)obj21);
        CommandSet cmdSet22 = cmdBuilder.buildCommandSet((Object)obj22);
        CompositeCommandSet composite1 = new CompositeCommandSet();
        composite1.add(cmdSet11);
        composite1.add(cmdSet12);
        CompositeCommandSet composite2 = new CompositeCommandSet();
        composite2.add(cmdSet21);
        composite2.add(cmdSet22);
        Dictionary dict1 = composite1.getCommandDictionary();
        Dictionary dict2 = composite2.getCommandDictionary();
        Assert.assertEquals((long)this.evaluateChecksum(dict1), (long)this.evaluateChecksum(dict2));
        byte[] dictSer1 = this.serialize(dict1);
        byte[] dictSer2 = this.serialize(dict2);
        Assert.assertEquals((long)this.evaluateChecksum(dictSer1), (long)this.evaluateChecksum(dictSer2));
        Dictionary finalDict1 = (Dictionary)this.deserialize(dictSer1);
        Dictionary finalDict2 = (Dictionary)this.deserialize(dictSer2);
        Assert.assertTrue((boolean)DictionaryUtils.areDictionariesEqual((Dictionary)finalDict2, (Dictionary)finalDict1));
        Assert.assertTrue((boolean)DictionaryUtils.areDictionariesEqual((Dictionary)dict1, (Dictionary)finalDict1));
    }

    private long evaluateChecksum(Object obj) {
        byte[] bytes = this.serialize(obj);
        CRC32 checksum = new CRC32();
        checksum.update(bytes);
        return checksum.getValue();
    }

    /*
     * Exception decompiling
     */
    private byte[] serialize(Object obj) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Object deserialize(byte[] bytes) {
        Object object;
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        try {
            GZIPInputStream is = new GZIPInputStream(bis);
            ObjectInputStream ois = new ObjectInputStream(is);
            Object result = ois.readObject();
            ((InputStream)is).close();
            ois.close();
            object = result;
        }
        catch (Throwable throwable) {
            try {
                try {
                    bis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ClassNotFoundException x) {
                throw new RuntimeException("Class not found while deserializing object embedded in message " + ((Object)((Object)this)).getClass(), x);
            }
            catch (IOException x) {
                throw new RuntimeException("Could not deserialize object embedded in message " + ((Object)((Object)this)).getClass(), x);
            }
        }
        bis.close();
        return object;
    }
}

