/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import junit.framework.TestCase;
import org.lsst.ccs.command.AmbiguousCommandException;
import org.lsst.ccs.command.BasicCommand;
import org.lsst.ccs.command.CommandDictionaryBuilder;
import org.lsst.ccs.command.CommandSetBuilder;
import org.lsst.ccs.command.CompositeCommandSet;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryArgument;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.DictionaryUtils;
import org.lsst.ccs.command.Options;
import org.lsst.ccs.command.SupportedOption;
import org.lsst.ccs.command.TokenizedCommand;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.command.annotations.Option;
import org.lsst.ccs.command.demo.AmbiguousCommands;
import org.lsst.ccs.command.demo.DemoCommands;
import org.lsst.ccs.command.demo.RCMReg;

public class DictionaryBuilderTest
extends TestCase {
    public void testCreateCommandDictionary() {
        CommandDictionaryBuilder builder = new CommandDictionaryBuilder(DemoCommands.class);
        Dictionary dict = builder.getCommandDictionary();
        DictionaryBuilderTest.assertEquals((int)12, (int)dict.size());
        DictionaryCommand cd = DictionaryUtils.findCommand((Dictionary)dict, (String)"add", (int)2);
        DictionaryBuilderTest.assertEquals((int)2, (int)cd.getArguments().length);
        DictionaryBuilderTest.assertEquals((String)"add", (String)cd.getCommandName());
        DictionaryBuilderTest.assertEquals((String)"a", (String)cd.getArguments()[0].getName());
        DictionaryBuilderTest.assertEquals((String)"b", (String)cd.getArguments()[1].getName());
        DictionaryBuilderTest.assertEquals((int)99999, (int)cd.getLevel());
        DictionaryBuilderTest.assertFalse((boolean)cd.isVarArgs());
        cd = DictionaryUtils.findCommand((Dictionary)dict, (String)"addAll", (int)2);
        DictionaryArgument arg = cd.getArguments()[1];
        DictionaryBuilderTest.assertTrue((boolean)cd.isVarArgs());
        DictionaryBuilderTest.assertEquals((String)"double", (String)arg.getSimpleType());
        DictionaryBuilderTest.assertEquals((String)"double", (String)arg.getType());
        cd = DictionaryUtils.findCommand((Dictionary)dict, (String)"echoWithVarArgs", (int)1);
        arg = cd.getArguments()[0];
        DictionaryBuilderTest.assertTrue((boolean)cd.isVarArgs());
        DictionaryBuilderTest.assertEquals((String)"String", (String)arg.getSimpleType());
        DictionaryBuilderTest.assertEquals((String)"java.lang.String", (String)arg.getType());
        cd = DictionaryUtils.findCommand((Dictionary)dict, (String)"ACrazyLongNameToTestIfHelpFormatingWorks", (int)0);
        DictionaryBuilderTest.assertEquals((int)1, (int)cd.getLevel());
    }

    public void testCreateCommandDictionary2() {
        CommandDictionaryBuilder builder = new CommandDictionaryBuilder(RCMReg.class);
        Dictionary dict = builder.getCommandDictionary();
        DictionaryBuilderTest.assertEquals((int)4, (int)dict.size());
    }

    public void testCommandDictionaryEnum() {
        CommandDictionaryBuilder builder = new CommandDictionaryBuilder(DemoCommands.class);
        Dictionary dict = builder.getCommandDictionary();
        DictionaryCommand dc = DictionaryUtils.findCommand((Dictionary)dict, (String)"dayOfWeek", (int)1);
        DictionaryBuilderTest.assertEquals((String)"dayOfWeek", (String)dc.getCommandName());
        DictionaryBuilderTest.assertEquals((int)1, (int)dc.getArguments().length);
        DictionaryBuilderTest.assertEquals((String)"org.lsst.ccs.command.demo.DemoCommands.Day", (String)dc.getArguments()[0].getType());
        DictionaryBuilderTest.assertEquals((String)"Day", (String)dc.getArguments()[0].getSimpleType());
        DictionaryBuilderTest.assertEquals((int)7, (int)dc.getArguments()[0].getAllowedValues().size());
    }

    public void testCommandDictionaryAlias() {
        CommandDictionaryBuilder builder = new CommandDictionaryBuilder(DemoCommands.class);
        Dictionary dict = builder.getCommandDictionary();
        DictionaryCommand dc = DictionaryUtils.findCommand((Dictionary)dict, (String)"gt", (int)1);
        DictionaryBuilderTest.assertEquals((String)"getTemperature", (String)dc.getCommandName());
        DictionaryBuilderTest.assertEquals((int)1, (int)dc.getArguments().length);
    }

    public void testCommandDictionaryAlias2() {
        CommandDictionaryBuilder builder = new CommandDictionaryBuilder(DemoCommands.class);
        Dictionary dict = builder.getCommandDictionary();
        DictionaryCommand dc = DictionaryUtils.findCommand((Dictionary)dict, (String)"day", (int)1);
        DictionaryBuilderTest.assertEquals((String)"dayOfWeek", (String)dc.getCommandName());
        DictionaryBuilderTest.assertEquals((int)1, (int)dc.getArguments().length);
        DictionaryBuilderTest.assertEquals((String)"org.lsst.ccs.command.demo.DemoCommands.Day", (String)dc.getArguments()[0].getType());
        DictionaryBuilderTest.assertEquals((String)"Day", (String)dc.getArguments()[0].getSimpleType());
        DictionaryBuilderTest.assertEquals((int)7, (int)dc.getArguments()[0].getAllowedValues().size());
    }

    public void testDefaultParameterNames() throws Exception {
        DictionaryBuilderTest.assertEquals((String)DemoCommands.class.getMethod("getTemperature", Integer.TYPE).getParameters()[0].getName(), (String)"module");
    }

    public void testAmbiguousCommands() {
        try {
            CommandDictionaryBuilder dict = new CommandDictionaryBuilder(AmbiguousCommands.class);
            DictionaryBuilderTest.fail((String)"Ambiguous command should have thrown an exception");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testAmbiguousCommandsWithDefaultValues() {
        CommandSetBuilder builder = new CommandSetBuilder();
        CompositeCommandSet compositeSet = new CompositeCommandSet();
        try {
            compositeSet.add(builder.buildCommandSet((Object)new Commands()));
        }
        catch (AmbiguousCommandException e) {
            return;
        }
        DictionaryBuilderTest.assertTrue((boolean)false);
    }

    public void testAddingAmbiguousCommandsWithDefaultValues() {
        CommandSetBuilder builder = new CommandSetBuilder();
        CompositeCommandSet compositeSet = new CompositeCommandSet();
        compositeSet.add(builder.buildCommandSet((Object)new Commands1()));
        try {
            compositeSet.add(builder.buildCommandSet((Object)new Commands2()));
        }
        catch (AmbiguousCommandException e) {
            return;
        }
        DictionaryBuilderTest.assertTrue((boolean)false);
    }

    public void testAmbiguousCommandsWhenAddingCommandCompositeSets() {
        CommandSetBuilder builder = new CommandSetBuilder();
        CompositeCommandSet compositeSet = new CompositeCommandSet();
        compositeSet.add(builder.buildCommandSet((Object)new DemoCommands()));
        try {
            compositeSet.add(builder.buildCommandSet((Object)new DemoCommands()));
        }
        catch (AmbiguousCommandException e) {
            return;
        }
        DictionaryBuilderTest.assertTrue((boolean)false);
    }

    public void testCommandsWithDefaults() {
        CommandDictionaryBuilder builder = new CommandDictionaryBuilder(DemoCommands.class);
        Dictionary dict = builder.getCommandDictionary();
        DictionaryCommand dc = DictionaryUtils.findCommand((Dictionary)dict, (String)"zcommandWithDefault", (int)1);
        DictionaryBuilderTest.assertEquals((String)"zcommandWithDefault", (String)dc.getCommandName());
        DictionaryCommand dc1 = DictionaryUtils.findCommand((Dictionary)dict, (String)"zcommandWithDefault", (int)0);
        DictionaryBuilderTest.assertEquals((String)"zcommandWithDefault", (String)dc1.getCommandName());
        DictionaryCommand dc2 = DictionaryUtils.findCommand((Dictionary)dict, (String)"zcommandWithEmptyDefault", (int)0);
        DictionaryBuilderTest.assertNull((Object)dc2);
        DictionaryCommand dc3 = DictionaryUtils.findCommand((Dictionary)dict, (String)"zcommandWithEmptyDefault", (int)1);
        DictionaryBuilderTest.assertEquals((String)"zcommandWithEmptyDefault", (String)dc3.getCommandName());
        DictionaryCommand dc4 = DictionaryUtils.findCommand((Dictionary)dict, (String)"zcommandWithEmptyDefault", (int)4);
        DictionaryBuilderTest.assertEquals((String)"zcommandWithEmptyDefault", (String)dc3.getCommandName());
    }

    public void testSimulatedCommands() {
        CommandDictionaryBuilder builder = new CommandDictionaryBuilder(SimulatedCommands.class);
        Dictionary dict = builder.getCommandDictionary();
        DictionaryBuilderTest.assertEquals((int)1, (int)dict.size());
    }

    public void testMissingOptionsAnnotation() {
        try {
            CommandDictionaryBuilder builder = new CommandDictionaryBuilder(MissingOptionsAnnotation.class);
            DictionaryBuilderTest.assertTrue((boolean)false);
        }
        catch (RuntimeException re) {
            DictionaryBuilderTest.assertTrue((boolean)re.getMessage().contains("no @Option annotations"));
        }
    }

    public void testTooManyOptionsArguments() {
        try {
            CommandDictionaryBuilder builder = new CommandDictionaryBuilder(TooManyOptionsArguments.class);
            DictionaryBuilderTest.assertTrue((boolean)false);
        }
        catch (RuntimeException re) {
            DictionaryBuilderTest.assertTrue((boolean)re.getMessage().contains("has one or more @Option annotations"));
        }
    }

    public void testOptionsArgumentWrongPosition() {
        try {
            CommandDictionaryBuilder builder = new CommandDictionaryBuilder(OptionsArgumentsWrongPosition.class);
            DictionaryBuilderTest.assertTrue((boolean)false);
        }
        catch (RuntimeException re) {
            DictionaryBuilderTest.assertTrue((boolean)re.getMessage().contains("but the Options argument is not the first"));
        }
    }

    public void testCommandsWithOptions() {
        CommandDictionaryBuilder builder = new CommandDictionaryBuilder(MethodsWithOptions.class);
        Dictionary dict = builder.getCommandDictionary();
        DictionaryBuilderTest.assertEquals((int)2, (int)dict.size());
        DictionaryCommand cmdWithTwoOptions = DictionaryUtils.findCommand((Dictionary)dict, (String)"commandWithTwoOptions", (int)1);
        DictionaryCommand cmdWithNoOptions = DictionaryUtils.findCommand((Dictionary)dict, (String)"commandWithNoOptions", (int)1);
        DictionaryBuilderTest.assertEquals((int)2, (int)cmdWithTwoOptions.getSupportedOptions().size());
        DictionaryBuilderTest.assertTrue((boolean)((SupportedOption)cmdWithTwoOptions.getSupportedOptions().get(1)).getName().equals("verbose"));
        DictionaryBuilderTest.assertTrue((boolean)((SupportedOption)cmdWithTwoOptions.getSupportedOptions().get(0)).getName().equals("d12"));
        DictionaryBuilderTest.assertEquals((int)0, (int)cmdWithNoOptions.getSupportedOptions().size());
    }

    public void testCommandsWithIllegalShortNameOptions() {
        try {
            CommandDictionaryBuilder builder = new CommandDictionaryBuilder(MethodsWithIllegalShortNames.class);
            Dictionary dict = builder.getCommandDictionary();
            DictionaryBuilderTest.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException e) {
            DictionaryBuilderTest.assertTrue((boolean)e.getMessage().contains("Method commandWithTwoOptions contains at least two options with single letter name = v"));
        }
    }

    public void testAddingAmbiguousCommandsWithDefaultValuesNew() throws Exception {
        CommandSetBuilder builder = new CommandSetBuilder();
        CompositeCommandSet compositeSet = new CompositeCommandSet();
        compositeSet.add(builder.buildCommandSet((Object)new VarArg1()));
        compositeSet.add(builder.buildCommandSet((Object)new VarArg2()));
        compositeSet.getCommandDictionary().findCommand((BasicCommand)new TokenizedCommand("read 1"));
    }

    private class Commands {
        private Commands() {
        }

        @Command(description="long Args method", alias="callLong", type=Command.CommandType.QUERY)
        public boolean withLongParm(@Argument(defaultValue="1") long parm) {
            if (parm == 0L) {
                throw new IllegalArgumentException("arg should not be zero");
            }
            return true;
        }

        @Command(description="long Args method", alias="callLong", type=Command.CommandType.QUERY)
        public boolean withLongParm() {
            return true;
        }
    }

    private class Commands1 {
        private Commands1() {
        }

        @Command(description="long Args method", alias="callLong", type=Command.CommandType.QUERY)
        public boolean withLongParm(@Argument(defaultValue="1") long parm) {
            if (parm == 0L) {
                throw new IllegalArgumentException("arg should not be zero");
            }
            return true;
        }
    }

    private class Commands2 {
        private Commands2() {
        }

        @Command(description="long Args method", alias="callLong", type=Command.CommandType.QUERY)
        public boolean withLongParm() {
            return true;
        }
    }

    public class SimulatedCommands {
        @Command(name="simulateException", description="Simulate an Exception", simulation=true)
        public void simulateException() {
            throw new RuntimeException();
        }

        @Command(name="doSomething")
        public void doSomething() {
        }
    }

    public class MissingOptionsAnnotation {
        @Command
        public void missingOptionsAnnotation(String arg1, Options opts) {
        }
    }

    public class TooManyOptionsArguments {
        @Option(name="db")
        @Command
        public void tooManyOptionsAnnotation(Options opts, String arg1, Options o2) {
        }
    }

    public class OptionsArgumentsWrongPosition {
        @Option(name="dt")
        @Command
        public void wrongPositionOptionAnnotation(String arg1, Options opts) {
        }
    }

    public class MethodsWithOptions {
        @Option.List(value={@Option(name="d12"), @Option(name="verbose")})
        @Command
        public void commandWithTwoOptions(Options opts, String arg1) {
        }

        @Command
        public void commandWithNoOptions(String arg1) {
        }
    }

    public class MethodsWithIllegalShortNames {
        @Option.List(value={@Option(name="validate"), @Option(name="verbose")})
        @Command
        public void commandWithTwoOptions(Options opts, String arg1) {
        }

        @Command
        public void commandWithNoOptions(String arg1) {
        }
    }

    public class VarArg1 {
        @Command(name="read", description="Read response from device")
        public String read() {
            return "";
        }

        @Command(name="read", description="Write command and read response")
        public String read(@Argument(name="command", description="Command word") String command, @Argument(name="something", description="Arguments") String something, String ... args) {
            StringBuilder cmnd = new StringBuilder(command);
            for (String arg : args) {
                cmnd.append(" ").append(arg);
            }
            return cmnd.toString();
        }
    }

    public class VarArg2 {
        @Command(name="read", description="Write command and read response")
        public String read(@Argument(name="command", description="Command word") String command) {
            return command;
        }
    }
}

