package org.lsst.ccs.command.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Annotation for a Command Option. 
 * Allows to specify the name of a command Option.
 *
 * Options have a name and can be specified on the command line starting with a dash "-".
 * 
 * @author The LSST CCS Team
 */
@Repeatable(Option.List.class)
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface Option {

    /**
     * The name of the option as specified on the command line.
     * This name cannot be null or empty.
     * 
     * Options can be invoked on the command line by using double slashes "--".
     * 
     * @return The Option name.
     */
    String name();

    /**
     * Specify the description of the Option.
     *
     * @return option's description or "" if not set.
     */
    String description() default "";

    /**
     * The single letter name of the option as specified on the command line.
     * If unspecified the first letter of the name will be used.
     * 
     * Single letter names can be used on the command line by using a single slash "-".
     * Single letter names can be concatenated on the command line.
     * 
     * @return The Option single letter name.
     */
    String singleLetterName() default "";

    @Retention(RetentionPolicy.RUNTIME)
    @Target(ElementType.METHOD)
    @Documented
    @interface List {
        Option[] value();
    }
    
}
