package org.lsst.ccs.command;

import java.io.Serializable;

/**
 * A interface implemented by both TokenizedCommand and RawCommand
 * @author tonyj
 */
public interface BasicCommand extends Serializable {

    /**
     * Get the number of arguments associated with this command
     * @return The argument count
     */
    int getArgumentCount();

    /**
     * Get the root command name (the zeroth token)
     * @return The command name
     */
    String getCommand();
   
    Object getArgument(int i);
    
    Object[] getArguments();
    
    default public String prettyToString() {
        String res = "Command("+getClass().getSimpleName()+") "+getCommand();
        if ( getArgumentCount() > 0 ) {
            String arg = "argument";
            if ( getArgumentCount() > 1 ) { arg += "s"; }
            res += " with "+getArgumentCount()+" "+arg+" (";
            for ( int i = 0; i < getArgumentCount(); i++ ) {
                res += getArgument(i)+" ("+getArgument(i).getClass().getCanonicalName()+")";
                if ( i < getArgumentCount()-1 ) {
                    res+=",";
                }
            }
            res+=")";
        }
        if ( getOptions().hasOptions() ) {
            res += " "+getOptions().toString();
        }
        return res;
    }

    /**
     * Get the Options passed to this command.
     * 
     * @return The Options object containing the Options that were passed to this command.
     */
    public Options getOptions();

    
}
