/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.command.CommandArgumentMatchException;

public class CommandArgumentMatchExceptionTest {
    @Test
    public void testThrowExceptionIfNeeded() throws Exception {
        System.out.println("throwExceptionIfNeeded");
        ArrayList<CommandArgumentMatchException> exceptions = new ArrayList<CommandArgumentMatchException>();
        String[] names = new String[]{"par0", "par1"};
        List<String> allowedValues = Arrays.asList("", "/", "abs", "x", "xx", "xxy", "xxu", "buyie", "1", "xxxtewdno", "xniurxx", "t", "eee", "bewcbew", "befo", "xx", "text", "entry", "1234", "dust", "xniurxxg", "txx", "eeer", "bewfgcbew", "xxxbefo", "xre", "text3", "daxx", "12345", "xxx11", "x3xx1", "wxx");
        exceptions.add(new CommandArgumentMatchException("command", 0, names, "xxx", allowedValues));
        try {
            CommandArgumentMatchException.throwExceptionIfNeeded(exceptions);
        }
        catch (CommandArgumentMatchException x) {
            Assert.assertEquals((Object)"illegal value \"xxx\" for argument \"par0\" in \"command par0 par1\". Allowed values: [xx, xxy, xxu, xxxtewdno, txx, xxxbefo, xxx11, x3xx1, wxx, x] and 21 more.", (Object)x.getMessage());
        }
        allowedValues = Arrays.asList("x", "x7x", "x44", "bewfgcbew");
        exceptions.add(new CommandArgumentMatchException("command", 0, names, "xxx", allowedValues));
        try {
            CommandArgumentMatchException.throwExceptionIfNeeded(exceptions);
        }
        catch (CommandArgumentMatchException x) {
            Assert.assertEquals((Object)"illegal value \"xxx\" for argument \"par0\" in \"command par0 par1\". Allowed values: [xx, xxy, xxu, xxxtewdno, txx, xxxbefo, xxx11, x3xx1, wxx, x7x] and 23 more.", (Object)x.getMessage());
        }
        allowedValues = Arrays.asList("x", "x7x");
        exceptions.add(new CommandArgumentMatchException("command", 1, names, "yyy", allowedValues));
        try {
            CommandArgumentMatchException.throwExceptionIfNeeded(exceptions);
        }
        catch (CommandArgumentMatchException x) {
            String expected = "illegal value \"yyy\" for argument \"par1\" in \"command par0 par1\". Allowed values: [x, x7x].\nOr illegal value \"xxx\" for argument \"par0\" in \"command par0 par1\". Allowed values: [xx, xxy, xxu, xxxtewdno, txx, xxxbefo, xxx11, x3xx1, wxx, x7x] and 23 more.";
            Assert.assertEquals((Object)expected, (Object)x.getMessage());
            exceptions = new ArrayList();
            exceptions.add(x);
            names = new String[]{"par0", "arg"};
            exceptions.add(new CommandArgumentMatchException("command", 1, names, "yyy", allowedValues));
            try {
                CommandArgumentMatchException.throwExceptionIfNeeded(exceptions);
            }
            catch (CommandArgumentMatchException xx) {
                expected = "illegal value \"yyy\" for argument \"par1\" in \"command par0 par1\". Allowed values: [x, x7x].\nOr illegal value \"yyy\" for argument \"arg\" in \"command par0 arg\". Allowed values: [x, x7x].\nOr illegal value \"xxx\" for argument \"par0\" in \"command par0 par1\". Allowed values: [xx, xxy, xxu, xxxtewdno, txx, xxxbefo, xxx11, x3xx1, wxx, x7x] and 23 more.";
                Assert.assertEquals((Object)expected, (Object)xx.getMessage());
            }
        }
    }
}

