/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.lsst.ccs.command.BasicCommand;
import org.lsst.ccs.command.CommandArgumentMatchException;
import org.lsst.ccs.command.CommandArgumentTypeException;
import org.lsst.ccs.command.CommandInvocationException;
import org.lsst.ccs.command.CommandSetBuilder;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.DictionaryUtils;
import org.lsst.ccs.command.RouteSelectionCommandSet;
import org.lsst.ccs.command.RoutingCommandSet;
import org.lsst.ccs.command.TokenizedCommand;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.command.routes.InnerRoute;
import org.lsst.ccs.command.routes.Route1;
import org.lsst.ccs.command.routes.Route2;
import org.lsst.ccs.command.routes.Route3;

public class CommandRoutesTest
extends TestCase {
    private final CommandSetBuilder builder = new CommandSetBuilder();
    private final RouteSelectionCommandSet routeSelection = new RouteSelectionCommandSet();

    protected void setUp() throws Exception {
        this.routeSelection.addRoutingCommandSet("route1", "route1", this.builder.buildCommandSet((Object)new Route1()));
        this.routeSelection.addRoutingCommandSet("route1/inner", "route1/inner", this.builder.buildCommandSet((Object)new InnerRoute()));
        this.routeSelection.addRoutingCommandSet("route2", "route2", this.builder.buildCommandSet((Object)new Route2()));
    }

    public void testRoutes() throws CommandInvocationException {
        CommandRoutesTest.assertTrue((boolean)DictionaryUtils.containsCommand((Dictionary)this.routeSelection.getCommandDictionary(), (String)"route1", (int)0));
        CommandRoutesTest.assertTrue((boolean)DictionaryUtils.containsCommand((Dictionary)this.routeSelection.getCommandDictionary(), (String)"route1/inner", (int)0));
        CommandRoutesTest.assertTrue((boolean)DictionaryUtils.containsCommand((Dictionary)this.routeSelection.getCommandDictionary(), (String)"route2", (int)0));
        CommandRoutesTest.assertFalse((boolean)DictionaryUtils.containsCommand((Dictionary)this.routeSelection.getCommandDictionary(), (String)"doSomethingRoute1", (int)0));
    }

    public void testActivateRoute() throws CommandInvocationException {
        this.routeSelection.setActiveRoute("route1");
        CommandRoutesTest.assertEquals((String)"route1", (String)this.routeSelection.getActiveRoute());
        CommandRoutesTest.assertTrue((boolean)DictionaryUtils.containsCommand((Dictionary)this.routeSelection.getCommandDictionary(), (String)"route1", (int)0));
        CommandRoutesTest.assertTrue((boolean)DictionaryUtils.containsCommand((Dictionary)this.routeSelection.getCommandDictionary(), (String)"route1/inner", (int)0));
        CommandRoutesTest.assertTrue((boolean)DictionaryUtils.containsCommand((Dictionary)this.routeSelection.getCommandDictionary(), (String)"inner", (int)0));
        CommandRoutesTest.assertTrue((boolean)DictionaryUtils.containsCommand((Dictionary)this.routeSelection.getCommandDictionary(), (String)"route2", (int)0));
        CommandRoutesTest.assertTrue((boolean)DictionaryUtils.containsCommand((Dictionary)this.routeSelection.getCommandDictionary(), (String)"doSomethingRoute1", (int)0));
        this.routeSelection.setActiveRoute("");
        CommandRoutesTest.assertEquals((String)"", (String)this.routeSelection.getActiveRoute());
        CommandRoutesTest.assertFalse((boolean)DictionaryUtils.containsCommand((Dictionary)this.routeSelection.getCommandDictionary(), (String)"inner", (int)0));
        CommandRoutesTest.assertFalse((boolean)DictionaryUtils.containsCommand((Dictionary)this.routeSelection.getCommandDictionary(), (String)"doSomethingRoute1", (int)0));
        CommandRoutesTest.assertTrue((boolean)DictionaryUtils.containsCommand((Dictionary)this.routeSelection.getCommandDictionary(), (String)"route1", (int)0));
        CommandRoutesTest.assertTrue((boolean)DictionaryUtils.containsCommand((Dictionary)this.routeSelection.getCommandDictionary(), (String)"route1/inner", (int)0));
        CommandRoutesTest.assertTrue((boolean)DictionaryUtils.containsCommand((Dictionary)this.routeSelection.getCommandDictionary(), (String)"route2", (int)0));
        try {
            this.routeSelection.setActiveRoute("abc");
            CommandRoutesTest.assertTrue((boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        CommandRoutesTest.assertEquals((String)"", (String)this.routeSelection.getActiveRoute());
        CommandRoutesTest.assertFalse((boolean)DictionaryUtils.containsCommand((Dictionary)this.routeSelection.getCommandDictionary(), (String)"inner", (int)0));
        CommandRoutesTest.assertFalse((boolean)DictionaryUtils.containsCommand((Dictionary)this.routeSelection.getCommandDictionary(), (String)"doSomethingRoute1", (int)0));
        CommandRoutesTest.assertTrue((boolean)DictionaryUtils.containsCommand((Dictionary)this.routeSelection.getCommandDictionary(), (String)"route1", (int)0));
        CommandRoutesTest.assertTrue((boolean)DictionaryUtils.containsCommand((Dictionary)this.routeSelection.getCommandDictionary(), (String)"route1/inner", (int)0));
        CommandRoutesTest.assertTrue((boolean)DictionaryUtils.containsCommand((Dictionary)this.routeSelection.getCommandDictionary(), (String)"route2", (int)0));
    }

    public void testRouteSelectionAllowedValues() throws CommandInvocationException, CommandArgumentMatchException, CommandArgumentTypeException {
        TokenizedCommand cmd = new TokenizedCommand("set target route1");
        DictionaryCommand dictCmd = this.routeSelection.getCommandDictionary().findCommand((BasicCommand)cmd);
        List allowedValues = dictCmd.getArguments()[1].getAllowedValues();
        CommandRoutesTest.assertTrue((boolean)allowedValues.contains("route1"));
        CommandRoutesTest.assertTrue((boolean)allowedValues.contains("route2"));
        CommandRoutesTest.assertTrue((boolean)allowedValues.contains("route1/inner"));
        CommandRoutesTest.assertEquals((int)allowedValues.size(), (int)3);
        this.routeSelection.invoke((BasicCommand)cmd);
        allowedValues = dictCmd.getArguments()[1].getAllowedValues();
        CommandRoutesTest.assertEquals((String)allowedValues.toString(), (int)4, (int)allowedValues.size());
        CommandRoutesTest.assertTrue((boolean)allowedValues.contains("inner"));
        this.routeSelection.addRoutingCommandSet("route1/inner/inner_inner", "route1/inner/inner_inner", this.builder.buildCommandSet((Object)new InnerRoute()));
        allowedValues = dictCmd.getArguments()[1].getAllowedValues();
        CommandRoutesTest.assertEquals((int)allowedValues.size(), (int)6);
        CommandRoutesTest.assertTrue((boolean)allowedValues.contains("inner/inner_inner"));
        CommandRoutesTest.assertTrue((boolean)allowedValues.contains("route1/inner/inner_inner"));
    }

    public void testRouteIllegalArgument() throws CommandInvocationException, CommandArgumentMatchException, CommandArgumentTypeException {
        TokenizedCommand cmd = new TokenizedCommand("set target fakeRoute");
        try {
            this.routeSelection.invoke((BasicCommand)cmd);
            CommandRoutesTest.assertTrue((boolean)false);
        }
        catch (CommandArgumentMatchException ex) {
            CommandRoutesTest.assertTrue((boolean)ex.getMessage().startsWith("illegal value \"fakeRoute"));
        }
    }

    public void testRouteLevels() throws Exception {
        ArrayList l = new ArrayList();
        this.routeSelection.getCommandDictionary().getDictionaryCompleter().complete("", 0, l);
        CommandRoutesTest.assertEquals((String)((Object)l).toString(), (int)5, (int)l.size());
        CommandRoutesTest.assertTrue((boolean)l.contains("route1/inner "));
        CommandRoutesTest.assertTrue((boolean)l.contains("set "));
        CommandRoutesTest.assertTrue((boolean)l.contains("get "));
        CommandRoutesTest.assertTrue((boolean)l.contains("route1 "));
        CommandRoutesTest.assertTrue((boolean)l.contains("route2 "));
        l.clear();
        this.routeSelection.getCommandDictionary().getDictionaryCompleter().complete("route1 ", 7, l);
        CommandRoutesTest.assertEquals((String)((Object)l).toString(), (int)3, (int)l.size());
        CommandRoutesTest.assertTrue((boolean)l.contains("testRoute1 "));
        CommandRoutesTest.assertTrue((boolean)l.contains("doSomethingRoute1 "));
        CommandRoutesTest.assertTrue((boolean)l.contains("set "));
        l.clear();
        this.routeSelection.getCommandDictionary().getDictionaryCompleter().complete("route1/inner ", 13, l);
        CommandRoutesTest.assertEquals((String)((Object)l).toString(), (int)4, (int)l.size());
        CommandRoutesTest.assertTrue((boolean)l.contains("testInnerRoute "));
        CommandRoutesTest.assertTrue((boolean)l.contains("doSomethingInnerRoute "));
        CommandRoutesTest.assertTrue((boolean)l.contains("set "));
        CommandRoutesTest.assertTrue((boolean)l.contains("lowLevelCommand "));
        l.clear();
        this.routeSelection.getCommandDictionary().getDictionaryCompleter().complete("route2 ", 7, l);
        CommandRoutesTest.assertEquals((String)((Object)l).toString(), (int)3, (int)l.size());
        CommandRoutesTest.assertTrue((boolean)l.contains("testRoute2 "));
        CommandRoutesTest.assertTrue((boolean)l.contains("doSomethingRoute2 "));
        CommandRoutesTest.assertTrue((boolean)l.contains("set "));
        l.clear();
        ((RoutingCommandSet)this.routeSelection.getRoutes().get("route1")).getCommandDictionary().setLevelForTypes(-1, new Command.CommandType[0]);
        this.routeSelection.getCommandDictionary().getDictionaryCompleter().complete("route1 ", 7, l);
        CommandRoutesTest.assertTrue((String)((Object)l).toString(), (boolean)l.isEmpty());
        ((RoutingCommandSet)this.routeSelection.getRoutes().get("route1")).getCommandDictionary().setLevelForTypes(4, new Command.CommandType[]{Command.CommandType.QUERY, Command.CommandType.ACTION});
        ((RoutingCommandSet)this.routeSelection.getRoutes().get("route1/inner")).getCommandDictionary().setLevelForTypes(8, new Command.CommandType[]{Command.CommandType.CONFIGURATION, Command.CommandType.ACTION});
        CommandRoutesTest.assertEquals((int)4, (int)((RoutingCommandSet)this.routeSelection.getRoutes().get("route1")).getCommandDictionary().getLevelForType(Command.CommandType.QUERY));
        CommandRoutesTest.assertEquals((int)-1, (int)((RoutingCommandSet)this.routeSelection.getRoutes().get("route1")).getCommandDictionary().getLevelForType(Command.CommandType.SIGNAL));
        CommandRoutesTest.assertEquals((int)8, (int)((RoutingCommandSet)this.routeSelection.getRoutes().get("route1/inner")).getCommandDictionary().getLevelForType(Command.CommandType.CONFIGURATION));
        CommandRoutesTest.assertEquals((int)99999, (int)((RoutingCommandSet)this.routeSelection.getRoutes().get("route2")).getCommandDictionary().getLevelForType(Command.CommandType.QUERY));
        this.routeSelection.getCommandDictionary().getDictionaryCompleter().complete("route1 ", 7, l);
        CommandRoutesTest.assertEquals((String)((Object)l).toString(), (int)1, (int)l.size());
        CommandRoutesTest.assertEquals((String)((Object)l).toString(), l.get(0), (Object)"testRoute1 ");
        l.clear();
        this.routeSelection.getCommandDictionary().getDictionaryCompleter().complete("route1/inner ", 13, l);
        CommandRoutesTest.assertEquals((String)((Object)l).toString(), (int)2, (int)l.size());
        CommandRoutesTest.assertTrue((boolean)l.contains("testInnerRoute "));
        CommandRoutesTest.assertTrue((boolean)l.contains("lowLevelCommand "));
        l.clear();
        this.routeSelection.getCommandDictionary().getDictionaryCompleter().complete("route2 ", 7, l);
        CommandRoutesTest.assertEquals((String)((Object)l).toString(), (int)3, (int)l.size());
        CommandRoutesTest.assertTrue((boolean)l.contains("testRoute2 "));
        CommandRoutesTest.assertTrue((boolean)l.contains("doSomethingRoute2 "));
        CommandRoutesTest.assertTrue((boolean)l.contains("set "));
        l.clear();
        this.routeSelection.getCommandDictionary().setLevelForTypes(0, Command.CommandType.values());
        this.routeSelection.getCommandDictionary().getDictionaryCompleter().complete("", 0, l);
        CommandRoutesTest.assertEquals((String)((Object)l).toString(), (int)3, (int)l.size());
        CommandRoutesTest.assertTrue((boolean)l.contains("route1/inner "));
        CommandRoutesTest.assertTrue((boolean)l.contains("set "));
        CommandRoutesTest.assertTrue((boolean)l.contains("get "));
        l.clear();
        this.routeSelection.addRoutingCommandSet("route3", "route3", this.builder.buildCommandSet((Object)new Route3()));
        ((RoutingCommandSet)this.routeSelection.getRoutes().get("route3")).getCommandDictionary().setLevelForTypes(-1, new Command.CommandType[0]);
        ((RoutingCommandSet)this.routeSelection.getRoutes().get("route3")).getCommandDictionary().setLevelForTypes(0, new Command.CommandType[]{Command.CommandType.QUERY});
        this.routeSelection.getCommandDictionary().getDictionaryCompleter().complete("route3 ", 7, l);
        CommandRoutesTest.assertEquals((String)((Object)l).toString(), (int)1, (int)l.size());
        CommandRoutesTest.assertTrue((boolean)l.contains("doSomethingLowLevelRoute3 "));
        l.clear();
        ((RoutingCommandSet)this.routeSelection.getRoutes().get("route3")).getCommandDictionary().setLevelForTypes(0, new Command.CommandType[0]);
        this.routeSelection.getCommandDictionary().getDictionaryCompleter().complete("route3 ", 7, l);
        this.routeSelection.getCommandDictionary().getDictionaryCompleter().complete("route2 ", 7, l);
        CommandRoutesTest.assertTrue((boolean)l.contains("doSomethingLowLevelRoute3 "));
        CommandRoutesTest.assertTrue((boolean)l.contains("actionRoute3 "));
        l.clear();
    }
}

