/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import junit.framework.TestCase;
import org.junit.Assert;
import org.lsst.ccs.command.CommandDictionaryBuilder;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.command.demo.CommandsWithDefaultArguments;

public class DictionaryLevelTest
extends TestCase {
    public void testCreateCommandDictionary() {
        CommandDictionaryBuilder builder = new CommandDictionaryBuilder(CommandsWithDefaultArguments.class);
        Dictionary dict = builder.getCommandDictionary();
        for (Command.CommandType t : Command.CommandType.values()) {
            Assert.assertTrue((dict.getLevelForType(t) == 99999 ? 1 : 0) != 0);
        }
        dict.setLevelForTypes(1, new Command.CommandType[]{Command.CommandType.CONFIGURATION});
        dict.setLevelForTypes(2, new Command.CommandType[]{Command.CommandType.ACTION});
        dict.setLevelForTypes(36, new Command.CommandType[]{Command.CommandType.QUERY, Command.CommandType.SIGNAL});
        Assert.assertTrue((dict.getLevelForType(Command.CommandType.CONFIGURATION) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((dict.getLevelForType(Command.CommandType.ACTION) == 2 ? 1 : 0) != 0);
        Assert.assertTrue((dict.getLevelForType(Command.CommandType.QUERY) == 36 ? 1 : 0) != 0);
        Assert.assertTrue((dict.getLevelForType(Command.CommandType.SIGNAL) == 36 ? 1 : 0) != 0);
        dict.setLevelForTypes(-1, new Command.CommandType[0]);
        for (Command.CommandType t : Command.CommandType.values()) {
            Assert.assertTrue((dict.getLevelForType(t) == -1 ? 1 : 0) != 0);
        }
    }
}

