/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.TestCase;
import org.lsst.ccs.command.BasicCommand;
import org.lsst.ccs.command.CommandArgumentMatchException;
import org.lsst.ccs.command.CommandArgumentTypeException;
import org.lsst.ccs.command.CommandInvocationException;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.CommandSetBuilder;
import org.lsst.ccs.command.CompositeCommandSet;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.Options;
import org.lsst.ccs.command.RawCommand;
import org.lsst.ccs.command.TokenizedCommand;
import org.lsst.ccs.command.demo.CommandsWithDefaultArguments;
import org.lsst.ccs.command.demo.DemoCommands;
import org.lsst.ccs.command.demo.DemoCommandsWithComplexArgs;
import org.lsst.ccs.command.demo.ExceptionCommands;
import org.lsst.ccs.command.demo.ExtendedDemoCommands;
import org.lsst.ccs.command.routes.InnerRoute;
import org.lsst.ccs.command.routes.Route1;
import org.lsst.ccs.command.routes.Route2;

public class CommandInvokerTest
extends TestCase {
    private CommandSet commandSet;
    private CommandSet extendedCommandSet;
    private CommandSet exceptionCommandSet;
    private CommandSet complexArgumentsCommandSet;
    private CommandSet argumentsWithDefaultsCommandSet;

    protected void setUp() throws Exception {
        CommandSetBuilder builder = new CommandSetBuilder();
        this.commandSet = builder.buildCommandSet((Object)new DemoCommands());
        this.extendedCommandSet = builder.buildCommandSet((Object)new ExtendedDemoCommands());
        this.exceptionCommandSet = builder.buildCommandSet((Object)new ExceptionCommands());
        this.complexArgumentsCommandSet = builder.buildCommandSet((Object)new DemoCommandsWithComplexArgs());
        this.argumentsWithDefaultsCommandSet = builder.buildCommandSet((Object)new CommandsWithDefaultArguments());
    }

    public void testInvokeCommand() throws CommandInvocationException, CommandArgumentMatchException, CommandArgumentTypeException {
        TokenizedCommand tc = new TokenizedCommand("add 5 6");
        Object result = this.commandSet.invoke((BasicCommand)tc);
        CommandInvokerTest.assertEquals((Object)11.0, (Object)result);
        tc = new TokenizedCommand("add -5 6");
        result = this.commandSet.invoke((BasicCommand)tc);
        CommandInvokerTest.assertEquals((Object)1.0, (Object)result);
    }

    public void testInvokeRawCommand() throws CommandInvocationException, CommandArgumentMatchException, CommandArgumentTypeException {
        RawCommand rc = new RawCommand("add", Arrays.asList(5, 6));
        Object result = this.commandSet.invoke((BasicCommand)rc);
        CommandInvokerTest.assertEquals((Object)11.0, (Object)result);
    }

    public void testInvokeCommand2() throws CommandInvocationException, CommandArgumentMatchException, CommandArgumentTypeException {
        TokenizedCommand tc = new TokenizedCommand("addAll base 5 6 7");
        Object result = this.commandSet.invoke((BasicCommand)tc);
        CommandInvokerTest.assertEquals((Object)18.0, (Object)result);
    }

    public void testInvokeCommand4() throws CommandInvocationException, CommandArgumentMatchException, CommandArgumentTypeException {
        TokenizedCommand tc = new TokenizedCommand("addAll base");
        Object result = this.commandSet.invoke((BasicCommand)tc);
        CommandInvokerTest.assertEquals((Object)0.0, (Object)result);
    }

    public void testInvokeCommand5() throws CommandInvocationException, CommandArgumentMatchException, CommandArgumentTypeException {
        TokenizedCommand tc = new TokenizedCommand("addAll base 999");
        Object result = this.commandSet.invoke((BasicCommand)tc);
        CommandInvokerTest.assertEquals((Object)999.0, (Object)result);
    }

    public void testInvokeRawCommand2() throws CommandInvocationException, CommandArgumentMatchException, CommandArgumentTypeException {
        RawCommand rc = new RawCommand("addAll", Arrays.asList("base", new double[]{5.0, 6.0, 7.0}));
        Object result = this.commandSet.invoke((BasicCommand)rc);
        CommandInvokerTest.assertEquals((Object)18.0, (Object)result);
    }

    public void testInvokeCommand3() throws CommandInvocationException, CommandArgumentMatchException, CommandArgumentTypeException {
        TokenizedCommand tc = new TokenizedCommand("add 1");
        try {
            this.commandSet.invoke((BasicCommand)tc);
            CommandInvokerTest.fail((String)"Exception should have been thrown");
        }
        catch (CommandInvocationException commandInvocationException) {
            // empty catch block
        }
    }

    public void testInvokeCommand6() throws CommandInvocationException, CommandArgumentMatchException, CommandArgumentTypeException {
        TokenizedCommand tc = new TokenizedCommand("addAll");
        try {
            this.commandSet.invoke((BasicCommand)tc);
            CommandInvokerTest.fail((String)"Exception should have been thrown");
        }
        catch (CommandInvocationException commandInvocationException) {
            // empty catch block
        }
    }

    public void testInvokeRawCommand3() throws CommandInvocationException, CommandArgumentMatchException, CommandArgumentTypeException {
        RawCommand rc = new RawCommand("add", Arrays.asList(1));
        try {
            this.commandSet.invoke((BasicCommand)rc);
            CommandInvokerTest.fail((String)"Exception should have been thrown");
        }
        catch (CommandInvocationException commandInvocationException) {
            // empty catch block
        }
    }

    public void testExtendedDemoCommand() throws CommandInvocationException, CommandArgumentMatchException, CommandArgumentTypeException {
        TokenizedCommand tc = new TokenizedCommand("add 5 6");
        Object result = this.extendedCommandSet.invoke((BasicCommand)tc);
        CommandInvokerTest.assertEquals((Object)12.0, (Object)result);
        tc = new TokenizedCommand("subtract 5 6");
        result = this.extendedCommandSet.invoke((BasicCommand)tc);
        CommandInvokerTest.assertEquals((Object)-1.0, (Object)result);
    }

    public void testTypeConversionException() throws CommandInvocationException, CommandArgumentMatchException, CommandArgumentTypeException {
        TokenizedCommand tc = new TokenizedCommand("add a d");
        try {
            Object result = this.extendedCommandSet.invoke((BasicCommand)tc);
            CommandInvokerTest.assertTrue((boolean)false);
        }
        catch (CommandArgumentTypeException e) {
            return;
        }
        CommandInvokerTest.assertTrue((boolean)false);
    }

    public void testCommandsWithDefaults() throws CommandInvocationException, CommandArgumentMatchException, CommandArgumentTypeException {
        TokenizedCommand tc = new TokenizedCommand("zcommandWithDefault");
        Object resultWithDefault = this.commandSet.invoke((BasicCommand)tc);
        CommandInvokerTest.assertEquals((Object)1, (Object)resultWithDefault);
        tc = new TokenizedCommand("zcommandWithDefault 15");
        Object resultWithValue = this.commandSet.invoke((BasicCommand)tc);
        CommandInvokerTest.assertEquals((Object)15, (Object)resultWithValue);
        tc = new TokenizedCommand("zcommandWithEmptyDefault abc");
        Object r = this.commandSet.invoke((BasicCommand)tc);
        CommandInvokerTest.assertEquals((Object)"abc", (Object)r);
        tc = new TokenizedCommand("zcommandWithEmptyDefault abc def");
        r = this.commandSet.invoke((BasicCommand)tc);
        CommandInvokerTest.assertEquals((Object)"abcdef", (Object)r);
    }

    public void testEnumArgumentDemoCommand() throws CommandInvocationException, CommandArgumentMatchException, CommandArgumentTypeException {
        TokenizedCommand tc = new TokenizedCommand("dayOfWeek TUESDAY");
        Object result = this.commandSet.invoke((BasicCommand)tc);
        CommandInvokerTest.assertEquals((Object)2, (Object)result);
        tc = new TokenizedCommand("dayOfWeek TuEsDaY");
        result = this.commandSet.invoke((BasicCommand)tc);
        CommandInvokerTest.assertEquals((Object)2, (Object)result);
        tc = new TokenizedCommand("dayOfWeek fakeDay");
        try {
            result = this.commandSet.invoke((BasicCommand)tc);
            CommandInvokerTest.assertFalse((boolean)true);
        }
        catch (CommandArgumentMatchException | CommandInvocationException ex) {
            CommandInvokerTest.assertTrue((boolean)(ex instanceof CommandArgumentMatchException));
            CommandInvokerTest.assertTrue((boolean)ex.getMessage().startsWith("Illegal value \"fakeDay\" for argument \"Day\""));
        }
    }

    public void testExecutionOfMultipleCommands() throws CommandInvocationException, CommandArgumentMatchException, CommandArgumentTypeException {
        CompositeCommandSet allCommands = new CompositeCommandSet();
        CommandSetBuilder builder = new CommandSetBuilder();
        CommandSet route1 = builder.buildCommandSet((Object)new Route1());
        CommandSet inner = builder.buildCommandSet((Object)new InnerRoute());
        CommandSet route2 = builder.buildCommandSet((Object)new Route2());
        allCommands.add(route1);
        allCommands.add(route2);
        allCommands.add(inner);
        TokenizedCommand cmd = new TokenizedCommand("set route2_id 10");
        DictionaryCommand command = allCommands.getCommandDictionary().findCommand((BasicCommand)cmd);
        Object res = allCommands.invoke((BasicCommand)cmd);
        CommandInvokerTest.assertEquals((Object)"Setting route2_id to 10 on ROUTE2", (Object)res);
        cmd = new TokenizedCommand("set route1_test 15");
        command = allCommands.getCommandDictionary().findCommand((BasicCommand)cmd);
        res = allCommands.invoke((BasicCommand)cmd);
        CommandInvokerTest.assertEquals((Object)"Setting route1_test to 15 on ROUTE1", (Object)res);
        cmd = new TokenizedCommand("set inner_route_test abc");
        command = allCommands.getCommandDictionary().findCommand((BasicCommand)cmd);
        res = allCommands.invoke((BasicCommand)cmd);
        CommandInvokerTest.assertEquals((Object)"Setting inner_route_test to abc on INNER_ROUTE", (Object)res);
    }

    public void testInvokationException() {
        TokenizedCommand cmd = new TokenizedCommand("throwException abc");
        try {
            this.exceptionCommandSet.invoke((BasicCommand)cmd);
            CommandInvokerTest.assertTrue((boolean)false);
        }
        catch (Exception ex) {
            CommandInvokerTest.assertEquals((String)"java.lang.IllegalArgumentException: Value abc is illegal", (String)ex.getMessage());
        }
    }

    public void testMethodsWithComplexArguments() throws Exception {
        TokenizedCommand tc = new TokenizedCommand("sumArray [1, 3,5 ,4  ] ");
        Object result = this.complexArgumentsCommandSet.invoke((BasicCommand)tc);
        CommandInvokerTest.assertEquals((Object)result, (Object)13);
        tc = new TokenizedCommand("sumArray \"[1, 3,5 ,4  ]\" ");
        result = this.complexArgumentsCommandSet.invoke((BasicCommand)tc);
        CommandInvokerTest.assertEquals((Object)result, (Object)13);
        tc = new TokenizedCommand("sumList [1, 33,5 ,4  ] ");
        result = this.complexArgumentsCommandSet.invoke((BasicCommand)tc);
        CommandInvokerTest.assertEquals((Object)result, (Object)43);
        tc = new TokenizedCommand("sumList \"[1, 3,5 ,44  ]\" ");
        result = this.complexArgumentsCommandSet.invoke((BasicCommand)tc);
        CommandInvokerTest.assertEquals((Object)result, (Object)53);
        tc = new TokenizedCommand("sumMap [1:abc, 3:ddd,5:#$ ,4:re  ] ");
        result = this.complexArgumentsCommandSet.invoke((BasicCommand)tc);
        CommandInvokerTest.assertEquals((Object)result, (Object)"abcddd#$re13");
        tc = new TokenizedCommand("sumListOfList [[1, 3,5 ,4  ], [4,5], [7]] ");
        result = this.complexArgumentsCommandSet.invoke((BasicCommand)tc);
        CommandInvokerTest.assertEquals((Object)result, (Object)29);
    }

    public void testDefaultArguments() throws Exception {
        TokenizedCommand tc = new TokenizedCommand("endIntegration");
        Object result = this.argumentsWithDefaultsCommandSet.invoke((BasicCommand)tc);
        CommandInvokerTest.assertEquals((Object)result, (Object)((Object)CommandsWithDefaultArguments.READOUT_MODE.TRUE));
        tc = new TokenizedCommand("endIntegration PSEUDO");
        result = this.argumentsWithDefaultsCommandSet.invoke((BasicCommand)tc);
        CommandInvokerTest.assertEquals((Object)result, (Object)((Object)CommandsWithDefaultArguments.READOUT_MODE.PSEUDO));
        tc = new TokenizedCommand("clear");
        result = this.argumentsWithDefaultsCommandSet.invoke((BasicCommand)tc);
        CommandInvokerTest.assertEquals((Object)result, (Object)1);
        tc = new TokenizedCommand("clear 1234");
        result = this.argumentsWithDefaultsCommandSet.invoke((BasicCommand)tc);
        CommandInvokerTest.assertEquals((Object)result, (Object)1234);
        tc = new TokenizedCommand("startIntegration");
        result = this.argumentsWithDefaultsCommandSet.invoke((BasicCommand)tc);
        CommandInvokerTest.assertEquals((Object)result, (Object)"");
        tc = new TokenizedCommand("startIntegration 1234 [a]");
        result = this.argumentsWithDefaultsCommandSet.invoke((BasicCommand)tc);
        CommandInvokerTest.assertEquals((Object)result, (Object)"1234a");
        tc = new TokenizedCommand("startIntegration 43231");
        result = this.argumentsWithDefaultsCommandSet.invoke((BasicCommand)tc);
        CommandInvokerTest.assertEquals((Object)result, (Object)"43231");
    }

    public void testCommandWithOptions() throws Exception {
        TokenizedCommand tc = new TokenizedCommand("echoWithOptions abc");
        Object result = this.commandSet.invoke((BasicCommand)tc);
        CommandInvokerTest.assertEquals((Object)result, (Object)"abc");
        tc = new TokenizedCommand("echoWithOptions abc --uppercase");
        result = this.commandSet.invoke((BasicCommand)tc);
        CommandInvokerTest.assertEquals((Object)result, (Object)"ABC");
        tc = new TokenizedCommand("echoWithOptions --invert abc --uppercase");
        result = this.commandSet.invoke((BasicCommand)tc);
        CommandInvokerTest.assertEquals((Object)result, (Object)"CBA");
        tc = new TokenizedCommand("echoWithOptions -ui abc ");
        result = this.commandSet.invoke((BasicCommand)tc);
        CommandInvokerTest.assertEquals((Object)result, (Object)"CBA");
        tc = new TokenizedCommand("echoWithOptions --invert abc");
        result = this.commandSet.invoke((BasicCommand)tc);
        CommandInvokerTest.assertEquals((Object)result, (Object)"cba");
        try {
            tc = new TokenizedCommand("echoWithOptions --inve abc");
            result = this.commandSet.invoke((BasicCommand)tc);
            CommandInvokerTest.assertTrue((boolean)false);
        }
        catch (Exception e) {
            CommandInvokerTest.assertTrue((boolean)e.getMessage().contains("Option inve is not one of the supported options"));
        }
        try {
            tc = new TokenizedCommand("echo --inve abc");
            result = this.commandSet.invoke((BasicCommand)tc);
            CommandInvokerTest.assertTrue((boolean)false);
        }
        catch (Exception e) {
            CommandInvokerTest.assertTrue((boolean)e.getMessage().contains("Options cannot be provided to a command that does not support them."));
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add("abc");
        RawCommand rc = new RawCommand("echoWithOptions", args);
        result = this.commandSet.invoke((BasicCommand)rc);
        CommandInvokerTest.assertEquals((Object)result, (Object)"abc");
        Options opts = new Options();
        opts.withOption("invert");
        rc = new RawCommand("echoWithOptions", args, opts);
        result = this.commandSet.invoke((BasicCommand)rc);
        CommandInvokerTest.assertEquals((Object)result, (Object)"cba");
        opts.withOption("uppercase");
        rc = new RawCommand("echoWithOptions", args, opts);
        result = this.commandSet.invoke((BasicCommand)rc);
        CommandInvokerTest.assertEquals((Object)result, (Object)"CBA");
        args.add((String)opts);
        rc = new RawCommand("echoWithOptions", args);
        result = this.commandSet.invoke((BasicCommand)rc);
        CommandInvokerTest.assertEquals((Object)result, (Object)"CBA");
    }
}

