package org.lsst.ccs.command.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Annotation for parameters of Command-marked methods. 
 */
@Target(ElementType.PARAMETER)
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface Argument {

    public static final String NULL = "***NULL_VALUE_FOR_COMMAND_ARGUMENT***";
    public static final String NOT_SET = "***NOT_SET_INITIAL_VALUE***";
    
    /**
     * Optional parameter name. If not set the argument name will be the default
     * name of the method's argument. If the class file has been compiled with 
     * Java 8 compiler argument "-parameters", the default name will be as specified in 
     * the class file, otherwise it will be "argN" where N is the index of the 
     * argument in the method's definition.
     *
     * @return The name of the argument.
     */
    String name() default "";

    /**
     * One-sentence description of the parameter.
     *
     * @return Short description of the annotated argument.
     */
    String description() default "";

    /**
     * Default value for this Argument.
     *
     * @return the default value for this Argument.
     */
    String defaultValue() default NOT_SET;
    
    /**
     * For arguments with a dynamic set of allowed values specify the name of
     * the AllowedValueProvider that will return the list of allowed values
     * The default is an empty string to specify that there is no provider.
     * 
     * @return the name of the AllowedValueProvider.
     */
    String allowedValueProvider() default "";
}
