package org.lsst.ccs.command;

import java.io.Serializable;

/**
 * A Class describing a supported Option.
 * 
 * For now we only support options with no arguments.
 * 
 */
public class SupportedOption implements Serializable {

    private final String name;
    private final String description;
    private final String singleLetterName;
    
    private static final long serialVersionUID = 5467389675408544L;

    public SupportedOption(String name, String description, String singleLetter) {
        if (  name == null || name.length() < 2 || !StringTokenizer.isOption("--"+name)) {
            throw new IllegalArgumentException("An Option name cannot be null, must contain at least two characters and start with a letter: "+name+".");
        }
        if ( singleLetter == null || singleLetter.length() > 1 || !StringTokenizer.isShortOption("-"+singleLetter)) {
            throw new IllegalArgumentException("An Option single letter name cannot be null, have size longer than 1 and it must be a letter:"+singleLetter+" .");            
        }
        this.name = name;
        this.description = description;
        this.singleLetterName = singleLetter.isEmpty() ? name.substring(0,1) : singleLetter;        
    }

    public String getName() {
        return name;
    }

    public String getSingleLetterName() {
        return singleLetterName;
    }
    
    public String getDescription() {
        return description;
    }

    @Override
    public String toString() {
        return "SupportedOption{" + "name=" + name + ", description=" + description + '}';
    }
    
}
