package org.lsst.ccs.shell;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jline.console.ConsoleReader;
import jline.console.completer.CandidateListCompletionHandler;

/**
 * Extend JLine's built-in completion handler to handle giving
 * information on specific parameters. 
 * @author tonyj
 */
class CommandCompletionHandler extends CandidateListCompletionHandler {

    @Override
    public boolean complete(ConsoleReader reader, List<CharSequence> candidates, int pos) throws IOException {

        ArrayList<CharSequence> helpCandidates = new ArrayList<>();
        for(CharSequence candidate: candidates) {
            if ( candidate.toString().startsWith("# ") ) {
                helpCandidates.add(candidate);
            }
        }
        
        if ( helpCandidates.size() == candidates.size() && candidates.size() > 0) {
            //FIXME: Using # to indicate parameter help is ugly
            reader.println();
            for ( CharSequence helpCandidate: helpCandidates ) {
                reader.println(helpCandidate.subSequence(1, helpCandidate.length()));                
            }
            reader.drawLine();
            return true;
        } else {
            for ( CharSequence helpCandidate: helpCandidates ) {
                candidates.remove(helpCandidate);
            }

            
            String toComplete = reader.getCursorBuffer().toString().substring(pos);
            int length = toComplete.length();

            //Tab completion should account for paths and only present the next
            //path component to reduce clutter on the console.
            ArrayList<CharSequence> pathAdjustedCandidates = new ArrayList<>();
            for (CharSequence candidate : candidates) {
                String candidateStr = candidate.toString();
                int ind = candidateStr.indexOf("/",length);
                if ( ind > 0 ) {
                    //This is a path: truncate at first "/";
                    candidateStr = candidateStr.substring(0, ind);
                }
                if (!pathAdjustedCandidates.contains(candidateStr)) {
                    pathAdjustedCandidates.add(candidateStr);
                }
            }        

            //If we have more than one element in pathAdjustedCandidates we might
            //end up having entry that differ exclusively by a trailing empty
            //space " ".
            //The extra space is useful when tab completing on a single element
            //to make it easier to continue typing on the command line.
            //But when we have multiple elements, the extra empty space is not needed
            //and the presence of its element confuses the tab completion.            
            Iterator<CharSequence> iter = pathAdjustedCandidates.iterator();
            while(iter.hasNext()) {
                String cs = iter.next().toString();
                if (cs.endsWith(" ") && pathAdjustedCandidates.contains(cs.trim())) {
                    iter.remove();
                }
            }
            
            //If we have only one element and the string to complete is identical
            //to the element itself, then it's a path and we add a "/" to it.
            if ( pathAdjustedCandidates.size() == 1 && pathAdjustedCandidates.get(0).equals(toComplete) ) {
                String path = pathAdjustedCandidates.remove(0).toString()+"/";
                pathAdjustedCandidates.add(path);
            }
            
            return super.complete(reader, pathAdjustedCandidates, pos);
        }
    }

    
}
